// This may look like C code, but it is really -*- C++ -*-
// Module PI : Peida Interactive  PINTuple et PINTupleWdg
// Traceur d objet de type NTupleInterface

#ifndef PINTUPLE_H
#define PINTUPLE_H

#include "ntupintf.h"
#include "pidrawer.h"

class PINTuple : public PIDrawer {
public:
                     PINTuple(NTupleInterface* nt, bool ad);
  virtual           ~PINTuple();
  
  virtual void       Draw(PIGraphicUC* g, double xmin, double ymin, double xmax, double ymax);
  virtual void       UpdateLimits();
  
  virtual void       SelectXY(const char* px, const char* py);
  virtual void       SelectWt(const char* pw=NULL, int nbins=10);
  virtual void       SelectErrBar(const char* erbx=NULL, const char* erby=NULL);
  virtual void       SelectLabel(const char* plabel=NULL);

  virtual void       AppendTextInfo(string& info, double xmin, double ymin, double xmax, double ymax);
       
protected:
  NTupleInterface* mNT;
  bool mAdDO;
  int xK, yK;          // Index du nom de variable en X/Y ds le ntuple
  int xebK, yebK;      // Index du nom de variable en ErrBarX/Y ds le ntuple
  int wK;              // Index du nom de variable poids
  int lK;              // Index du nom de variable label (affiche en texte)
  double wMin, wMax;        // Valeurs de poids min/max
  int nWbins;               // Nombre de bins pour le poids (Wt)

};

#endif




