#ifndef SPHEREGORSKI_SEEN
#define SPHEREGORSKI_SEEN

#include "sphericalmap.h"
#include "tvector.h"
#include "ndatablock.h"

#include "anydataobj.h"
#include "ppersist.h"


// ***************** CLASSE SphereGorski *****************************

template<class T>
class SphereGorski : public SphericalMap<T>,  public AnyDataObj 
{

public :

SphereGorski();
SphereGorski(int m);
SphereGorski(const SphereGorski<T>& s);
virtual ~SphereGorski();

// ------------------ Definition of PixelMap abstract methods

/* Nombre de pixels du decoupage */
virtual int NbPixels() const;
inline void setNbPixels(int n) {nPix_= n;}

/* Valeur du contenu du pixel d'indice "RING" k  */
virtual T& PixVal(int k);
virtual T const& PixVal(int k) const;

/* Nombre de tranches en theta */ 
int NbThetaSlices() const;
void GetThetaSlice(int index,double& theta,TVector<double>& phi,TVector<T>& value) const;

/* Indice "RING" du pixel vers lequel pointe une direction definie par 
ses  coordonnees spheriques */                                    
virtual int PixIndexSph(double theta,double phi) const;

/* Coordonnees spheriques du milieu du pixel d'indice "RING" k   */
virtual void PixThetaPhi(int k,double& theta,double& phi) const;

/* Pixel Solid angle  (steradians) */
virtual double PixSolAngle(int dummy) const;
inline void setPixSolAngle(double x) {omeg_= x;}

// --------------- Specific methods 

virtual void Resize(int m);

inline virtual char* TypeOfMap() const {return "RING";};

/* Valeur du contenu du pixel d'indice "NEST" k */
virtual T& PixValNest(int k);
virtual T const& PixValNest(int k) const;

/* Indice "NEST" du pixel vers lequel pointe une direction definie par 
ses  coordonnees spheriques */                                    
virtual int PixIndexSphNest(double theta,double phi) const;

/* Coordonnees spheriques du milieu du pixel d'indice "NEST" k       */
virtual void PixThetaPhiNest(int k,double& theta,double& phi) const;

/* algorithme de pixelisation */
void Pixelize(int); 

/* convertit index nested en ring  */
int NestToRing(int) const;

/* convertit index ring en nested" */
int RingToNest(int) const;


/* retourne/fixe la valeur du parametre Gorski */
inline virtual int SizeIndex() const {return(nSide_);}
inline void setSizeIndex(int n) {nSide_= n;}

/* retourne les pointeurs /remplit les tableaux */
inline const NDataBlock<T>* getDataBlock() const { return (&pixels_); }
inline void setDataBlock(T* data,int m) { pixels_.FillFrom(m,data); }



/* impression */ 
void print(ostream& os) const;
         
private :

// ------------- mthodes internes ----------------------
void InitNul();

int  nest2ring(int nside,int ipnest) const;
int  ring2nest(int nside,int ipring) const;

int  ang2pix_ring(int nside,double theta,double phi) const;
int  ang2pix_nest(int nside,double theta,double phi) const;
void pix2ang_ring(int nside,int ipix,double& theta,double& phi) const;
void pix2ang_nest(int nside,int ipix,double& theta,double& phi) const;

// ------------- variables internes -----------------------
int nSide_;
int nPix_;
double omeg_;

NDataBlock<T> pixels_;

};

//
// ------------- Classe pour la gestion de persistance --
//
template <class T>
class FIO_SphereGorski : public PPersist  
{
public:

FIO_SphereGorski();
FIO_SphereGorski(string const & filename); 
FIO_SphereGorski(const SphereGorski<T>& obj);
FIO_SphereGorski(SphereGorski<T>* obj);
virtual ~FIO_SphereGorski();
virtual AnyDataObj* DataObj();
inline operator SphereGorski<T>() { return(*dobj); }
inline SphereGorski<T> getObj() { return(*dobj); }

protected :

virtual void ReadSelf(PInPersist&);           
virtual void WriteSelf(POutPersist&) const;  
SphereGorski<T>* dobj;
bool ownobj;
};

//
// ------------- Classe PIXELS_XY -----------------------
//
class PIXELS_XY
{

public :

static PIXELS_XY& instance();

NDataBlock<int> pix2x_;
NDataBlock<int> pix2y_;
NDataBlock<int> x2pix_;
NDataBlock<int> y2pix_;

private :

PIXELS_XY();
void mk_pix2xy();
void mk_xy2pix();
};
#endif
