// Classe d'initialisation du module Outils++ 
#include <unistd.h>

#include "outilsinit.h"

#include "matrix.h"
#include "cvector.h"
#include "poly.h"
#include "dvlist.h"
#include "histos.h"
#include "histos2.h"
#include "hisprof.h"
#include "ntuple.h"
#include "generaldata.h"
#include "tmatrix.h"
#include "tvector.h"

#include "cimage.h"

#include "tabmath.h"
#include "dates.h"
#include "datime.h"

int PeidaOutilsInitiator::FgInit = 0;

PeidaOutilsInitiator::PeidaOutilsInitiator()
  : PeidaInitiator()
{
  FgInit++;
  if (FgInit > 1)  return;

//   Enregistrement des classes PPersist du modules Outils++
  
  PPRegister(Matrix);
  PPRegister(Vector);
  PPRegister(Poly);
  PPRegister(Poly2);
  PPRegister(ObjFileIO<DVList>);
  PPRegister(ObjFileIO<Histo>);
  PPRegister(ObjFileIO<Histo2D>);
  PPRegister(ObjFileIO<HProf>);

  PPRegister(ObjFileIO<NTuple>);
  PPRegister(ObjFileIO<GeneralFitData>);

  PPRegister(FIO_TMatrix<uint_1>);
  PPRegister(FIO_TMatrix<uint_2>);
  PPRegister(FIO_TMatrix<int_2>);
  PPRegister(FIO_TMatrix<int_4>);
  PPRegister(FIO_TMatrix<int_8>);
  PPRegister(FIO_TMatrix<uint_8>);
  PPRegister(FIO_TMatrix<r_4>);
  PPRegister(FIO_TMatrix<r_8>);
  PPRegister(FIO_TMatrix< complex<float> >);
  PPRegister(FIO_TMatrix< complex<double> >);

  PPRegister(FIO_TVector<uint_1>);
  PPRegister(FIO_TVector<uint_2>);
  PPRegister(FIO_TVector<int_2>);
  PPRegister(FIO_TVector<int_4>);
  PPRegister(FIO_TVector<int_8>);
  PPRegister(FIO_TVector<uint_8>);
  PPRegister(FIO_TVector<r_4>);
  PPRegister(FIO_TVector<r_8>);
  PPRegister(FIO_TVector< complex<float> >);
  PPRegister(FIO_TVector< complex<double> >);


  PPRegister(RzImage);
  PPRegister(ImageU2);
  PPRegister(ImageI2);
  PPRegister(ImageI4);
  PPRegister(ImageR4);

  //PPersistMgr::RegisterClass(Matrix::classId,  Matrix::Create);

  int pnice;
  char* snice = getenv("PEIDANICE");
  if (!snice) pnice=8;
  else pnice = atoi(snice);
  nice(pnice);

//  TSidSetupLaSilla();    Old-Eros

  gTimeZone = new TimeZone;

  ptabFExp = new TabFExp;

}

PeidaOutilsInitiator::~PeidaOutilsInitiator()
{
  FgInit--;
}


// On met un objet initiator en statique, pour les loaders qui savent 
// appeler le constructeur des objets statiques   Reza 08/98
static PeidaOutilsInitiator poutilsinit;

