#include <stdlib.h>
#include <stdio.h>

#include "pistdimgapp.h"
#include "piacmd.h"
#include "piversion.h"
#include "piaversion.h"

#include "timing.h"
#include "outilsinit.h"




/*  ================================ MAIN() =================================  */

int main(int narg, char *arg[])
{
int ofa;
int fgfpe, fgsegv, fgred, fgexec;

PeidaInit();
   
InitTim();

ofa = 1;   
if (narg > 1)
  {
  if (strcmp(arg[1],"-h") == 0) 
    {
    puts("\n piapp: Programme d'analyse interactive ");
    puts("Usage: piapp [-nored] [-nosig] [-nosigfpe] [-nosigsegv] [-help2tex] [-exec file [args]]");
    puts("  -nored : NoRedirect StdOut/StdErr");
    puts("  -nosig : Don't catch SigFPE, SigSEGV");
    puts("  -nosigfpe -nosigsegv: Don't catch SigFPE / SigSEGV");
    puts("  -help2tex: Create a LaTeX help file (piahelp.tex)");
    puts("  -exec file [args] : Execute command file \n");
    exit(0);
    }
  }

ofa = 1;
fgred = fgfpe = fgsegv = true;
fgexec = false;
string exfc;
// Pour fabriquer le help
bool fgtexh = false;
int ka;
for(ka=1; ka<narg; ka++) {
  if (strcmp(arg[ka],"-nored") == 0)   fgred=false; 
  else if (strcmp(arg[ka],"-nosig") == 0)   fgfpe=fgsegv=false; 
  else if (strcmp(arg[ka],"-nosigfpe") == 0)   fgfpe=false; 
  else if (strcmp(arg[ka],"-nosigsegv") == 0)   fgsegv=false; 
  else if (strcmp(arg[ka],"-help2tex") == 0) { fgtexh=true; fgred=false; }
  else if (strcmp(arg[ka],"-exec") == 0) {
    if (ka < narg-1) {
      fgexec = true;
      exfc = "exec";
      for(int kaa=ka+1; kaa<narg; kaa++)  { exfc += ' ';  exfc +=  arg[kaa]; }
      }
    break;
    }
  }

if (fgexec) printf(">>>>> Starting piapp , Executing %s \n", exfc.c_str()); 
else printf(">>>>> Starting piapp <<<<< \n");
printf("Version: piapp=%g  PI=%g  PEIDA=%g \n", (double)PIAPP_VERSIONNUMBER, 
              (double)PI_VERSIONNUMBER, (float)PeidaVersion());

PIStdImgApp * app = new PIStdImgApp(narg, arg);

// Gestion de redirection stdout/err et Signaux
if (fgred) app->RedirectStdOutErr(true);
else app->RedirectStdOutErr(false);
app->CatchSignals(fgfpe, fgsegv);

// S'il y a un fichier de commande a executer
if (fgexec) app->CmdInterpreter()->Interpret(exfc);

// S'il y a besoin de faire le fichier Help
if (fgtexh) { 
  string thf = "piahelp.tex";
  app->CmdInterpreter()->HelptoLaTex(thf);
  printf("piapp : Help file piahelp.tex created --> exit(0) \n"); 
  delete app;
  exit(0);
}

int rc = 0;
bool cont = true;
while(cont) {
  rc = 0;   cont = false;
  app->SetReady();
  if (fgred) app->RedirectStdOutErr(true);
  try {
  app->Run();
  }  catch ( PException exc ) {
     char ans[32],rep;
     app->Stop();
     app->RedirectStdOutErr(false);  
     fflush(stdout); 
     cout << endl; 
     cerr << endl;
     cerr << "PIStdImg/main() Exception catched ! " << exc.Msg() << endl;
     cerr << " continue <CR> , Stop program S<CR> ? " << endl;  gets(ans);
     rc = 9;
     rep = toupper(ans[0]);  
     if (rep == 'S')  { 
       printf(" !!!! Stopping piapp !!!! \n"); 
       cont = false;
       }
     else { 
       printf(" *** piapp - Continuing event loop *** \n");
       cont = true;
       }
//     else { cont = true; if (rep == 'K') app->CloseAllWindows(); }
  } ENDTRY;
}

app->RedirectStdOutErr(false);  
// On de-charge le module erospiamodule
delete app;

printf("piapp : Exiting .... Rc= %d \n", rc); 
exit(rc);
}

