// This may look like C code, but it is really -*- C++ -*-
//
// $Id: linfit.h,v 1.3 1999-10-25 10:36:08 ansari Exp $
//

// Routines de fit lineaire, avec ou sans erreurs, en fournissant
// les fonctions ou les valeurs.
#ifndef LINFIT_SEEN
#define LINFIT_SEEN

#include "machdefs.h"
class OMatrix;
class OVector;

double LinFit(const OVector& x, const OVector& y, int nf,
	   double (*f)(int, double), OVector& c);
// fit lineaire des y en tant que somme de c(i)f(i,x), i=0..nf-1;


double LinFit(const OMatrix& fx, const OVector& y, OVector& c);
// fit lineaire des y en tant que somme de c(i)f(i,x), i=0..nf-1,
// la matrice fx contient les valeurs des f:
// fx(i,j) = f(i, x(j)).
		      

double LinFit(const OVector& x, const OVector& y, const OVector& errY2, int nf,
	   double (*f)(int, double), OVector& c, OVector& errC);
// fit lineaire des y en tant que somme de c(i)f(i,x), i=0..nf-1,
// errY2 contient les carres des erreurs sur les Y.
// au retour, errC contient les erreurs sur les coefs.


double LinFit(const OMatrix& fx, const OVector& y, const OVector& errY2,
	   OVector& c, OVector& errC);
// fit lineaire des y en tant que somme de c(i)f(i,x), i=0..nf-1,
// la matrice fx contient les valeurs des f:
// fx(i,j) = f(i, x(j)).
// errY2 contient les carres des erreurs sur les Y.
// au retour, errC contient les erreurs sur les coefs.

#endif // LINFIT_SEEN 
