// This may look like C code, but it is really -*- C++ -*-

#ifndef PEIDA_CLASS_ID_H
#define PEIDA_CLASS_ID_H

// ClassIds pour Peida. Il est possible d'en definir d'autres, mais on regroupe
// ici toutes les classIds pour eviter des collisions.
//
// ClassIds pour utilisateur >= 0x4000
//

enum PeidaClassIds {

   ClassId_Unknown    = 0x0000,
//  Module Outils++
   ClassId_Poly1    = 0x0101,
   ClassId_Poly2    = 0x0102,
   ClassId_Matrix   = 0x0103,
   ClassId_Vector   = 0x0104,
   ClassId_DVList   = 0x0105,

   ClassId_PMatrixF = 0x0110,
   ClassId_PMatrixD = 0x0111,
   ClassId_PVectorF = 0x0112,
   ClassId_PVectorD = 0x0113,

   ClassId_Histo1D  = 0x0201,
   ClassId_Histo2D  = 0x0202,
   ClassId_HProf    = 0x0203,
   ClassId_NTuple   = 0x0210,
   ClassId_XNTuple  = 0x0211,

   ClassId_GeneralFitData  = 0x0290,

//  Module Images++
   ClassId_Image    = 0x0300,    // classId = 0x0300 + ImageType pour images types   
   ClassId_ZFidu    = 0x0330,
   ClassId_Voronoi  = 0x0340,
   ClassId_RLEImage = 0x0350,

//  Module StarReco++
   ClassId_StarList = 0x0500,
   ClassId_Transfo  = 0x0501,
   ClassId_PSF      = 0x0510,
   ClassId_Star     = 0x1000,     // Et ce qui suit, classId = 0x1000 + StarType

//  Module Samba
   ClassId_SphereTetaPhi  = 0x0611,
   ClassId_SphereGorski   = 0x0612,
   ClassId_LocalMap       = 0x0601,
   ClassId_Scan           = 0x0631,
   ClassId_MainLobe       = 0x0641
};

#endif
