// Classe d'initialisation du module Outils++ 
#include <unistd.h>

#include "sambainit.h"
#include "ppersist.h"
#include "objfio.h"
#include "spherethetaphi.h"
#include "spheregorski.h"
#include "spherepos.h"

int SambaInitiator::FgInit = 0;

SambaInitiator::SambaInitiator()
  : PeidaOutilsInitiator()
{
  SambaInitiator::FgInit++;
  if (SambaInitiator::FgInit > 1)  return;

//   Enregistrement des classes PPersist du modules Outils++
  
  PPRegister(SphereCoordSys);

  PPRegister(FIO_SphereThetaPhi<float>);
  PPRegister(FIO_SphereThetaPhi<double>);
  PPRegister(FIO_SphereThetaPhi< complex<float> >);
  PPRegister(FIO_SphereThetaPhi< complex<double> >);

  PPRegister(FIO_SphereGorski<float>);
  PPRegister(FIO_SphereGorski<double>);
  PPRegister(FIO_SphereGorski< complex<float> >);
  PPRegister(FIO_SphereGorski< complex<double> >);


}

SambaInitiator::~SambaInitiator()
{
  SambaInitiator::FgInit--;
}


// On met un objet initiator en statique, pour les loaders qui savent 
// appeler le constructeur des objets statiques   Reza 08/98
static SambaInitiator s_sambainit_;

