#ifndef PIBWDGGEN_H_SEEN
#define PIBWDGGEN_H_SEEN


#include "pisysdep.h"
#include PIWDG_H
#include PICMAP_H

// Mettre dans cet ordre, sinon g++ a des problemes   
#include <list>   


enum PIKeyModifier { PIKM_Blank = 0, PIKM_Shift = 1, PIKM_Alt = 2, PIKM_Cntl = 4 } ; 

enum PIColors  { PI_NotDefColor = -1, 
                 PI_Black = 0, PI_White = 1,  PI_Grey = 2,
                 PI_Red = 3, PI_Blue = 4, PI_Green = 5,  
                 PI_Yellow = 6, PI_Magenta = 7 }; 

enum PIFontSize { PI_NotDefFontSize = -1, 
                  PI_SmallSizeFont = 1, PI_NormalSizeFont = 2, PI_BigSizeFont = 3 };

enum PIFontAtt { PI_NotDefFontAtt = -1,
                 PI_RomanFont = 1, PI_BoldFont = 2, PI_ItalicFont = 4 };

enum PIPaperSize { PI_A4 = 1, PI_A3 = 2, PI_A5 = 3, PI_NotDefPaperSize = 0};

enum PIOrientation { PI_Landscape = 0, PI_Portrait = 1, PI_Auto = 2 } ;


enum PILineAtt { PI_NotDefLineAtt = -1,
                 PI_NormalLine = 0, PI_ThinLine = 1, PI_ThickLine = 2 };

enum PIMarker  { PI_NotDefMarker = -1,
                 PI_DotMarker = 0, PI_PlusMarker=1, PI_CrossMarker=2,  
                 PI_CircleMarker=3, PI_FCircleMarker=4,
                 PI_BoxMarker=5, PI_FBoxMarker=6,
                 PI_TriangleMarker=7, PI_FTriangleMarker=8,
                 PI_StarMarker=9, PI_FStarMarker=10 };

enum PIPointer { PI_ArrowPointer = 1, PI_CrossPointer = 2, 
                 PI_HandPointer = 3, PI_TDLRArrowPointer = 4 };

enum PIGOMode { PI_GOCopy = 0, PI_GOXOR = 1 }; 

class PIBaseWdgGen : public PIWdg
{
public:
  enum {ClassId = 5000};

// Les methodes ...

                     PIBaseWdgGen(PIContainerGen *par, char *nom,
                                   int sx=10, int sy=10, int px=0, int py=0);
  virtual            ~PIBaseWdgGen();

  virtual long       kind() {return ClassId; }

//  Activation des evenements   
  virtual void       ActivatePtrCross()        = 0;
  virtual void       ActivateButton(int bid)   = 0;
  virtual void       ActivateMove(int bid)     = 0;
  virtual void       ActivateKeyboard()        = 0;

//  Trace graphiques
  virtual void       EraseWindow(int x0=0, int y0=0, int dx=0, int dy=0)   = 0;
  virtual void       DrawString(int x, int y, char* s, int pos = 0)        = 0;
  virtual void       DrawLine(int x1, int y1, int x2, int y2)              = 0;
  virtual void       DrawBox(int x0, int y0, int dx, int dy)               = 0;
  virtual void       DrawFBox(int x0, int y0, int dx, int dy)              = 0;
  virtual void       DrawCircle(int x0, int y0, int r)                     = 0;
  virtual void       DrawFCircle(int x0, int y0, int r)                    = 0;
  virtual void       DrawPolygon(int *x, int *y, int n)                    = 0;  
  virtual void       DrawFPolygon(int *x, int *y, int n)                   = 0;  
  virtual void       DrawMarker(int x0, int y0)                            = 0;
  virtual void       DrawMarkers(int *x, int *y, int n)                    = 0;
  virtual void       DrawPixmap(int x, int y, unsigned char *pix, 
                                int sx, int sy, PIColorMap* cmap)          = 0;

  virtual int        CalcStringWidth(char const* s)                        = 0;

// Modifications attributs graphiques
  virtual void       SelForeground(PIColors col=PI_Black)                  = 0;
  virtual void       SelBackground(PIColors col=PI_White)                  = 0;
  virtual void       SelGOMode(PIGOMode mod=PI_GOCopy)                     = 0;
  virtual void       SelFont(PIFontSize sz=PI_NormalSizeFont, 
                             PIFontAtt att=PI_RomanFont)                   = 0;
  virtual void       SelFontSzPt(int npt=12, PIFontAtt att=PI_RomanFont)   = 0; 
  virtual void       SelLine(PILineAtt att=PI_NormalLine)                  = 0;
  virtual void       SelPointerShape(PIPointer ptr=PI_ArrowPointer)        = 0;
  virtual void       SelMarker(int msz=3, PIMarker mrk=PI_DotMarker)       = 0;

// Selection de zone de trace (clip)
  virtual void       SetClipRectangle(int x0, int y0, int dx, int dy)      = 0;
  virtual void       ClearClipRectangle() = 0;

// Acces aux attributs graphiques 
  virtual PIColors   GetForeground()    = 0;
  virtual PIColors   GetBackground()    = 0;
  virtual PIGOMode   GetGOMode()        = 0;
  virtual PIFontAtt  GetFontAtt()       = 0;
  virtual int        GetFontSize()      = 0;
  virtual PILineAtt  GetLineAtt()       = 0;
  virtual PIPointer  GetPointerShape()  = 0;
  virtual PIMarker   GetMarker()        = 0;
  virtual int        GetMarkerSize()    = 0;
  virtual int        GetFontHeight(int& asc, int& desc) = 0;

// Sauvegarde des attributs graphiques 
  virtual void       SaveGraphicAtt();
  virtual void       RestoreGraphicAtt();


//  Fonction qui doit etre appelee pour rafraichir (retracer) tout 
  virtual void       Refresh()          = 0;
  
// Traitement des evenements   
  virtual void       Resize()           = 0;
  virtual void       Draw()             = 0;
  virtual void       Draw(int x0, int y0, int dx, int dy) = 0;

  virtual void       Enter();
  virtual void       Leave();  
  virtual void       But1Press(int x, int y);  
  virtual void       But1Release(int x, int y); 
  virtual void       But2Press(int x, int y);
  virtual void       But2Release(int x, int y);
  virtual void       But3Press(int x, int y);
  virtual void       But3Release(int x, int y);
  virtual void       Ptr1Move(int x, int y);
  virtual void       Ptr2Move(int x, int y);
  virtual void       Ptr3Move(int x, int y);
  virtual void       Keyboard(int key, PIKeyModifier kmod);

// PostScript output
  virtual void       PSPrint(PSFile * psf, int ofx = 0, int ofy = 0);

// Gestion des Drawers 
  friend class PIDrawer;
          int        AddDrawer(PIDrawer* drw, int x0, int y0, int dx, int dy, 
                               bool ad=false);
          void       RemoveDrawer(int id);       // Ote un drawer de la liste
          void       DeleteDrawers();            // Ote et detruit tous les drawers

// Devrait etre protected - mis ici a cause de cxx  11/07/97  Reza
  struct BWDrwId { int x0, y0; int dx, dy; int id; bool ad; PIDrawer* drw; };
          
protected:
  virtual void       CallDrawers(int x0, int y0, int dx, int dy); // Appel le trace des drawers

  PSFile * mPSOut;  /* Fichier PostScript eventuel */

  bool mAdfg;
  int mDrwId;
  list<BWDrwId> mDrwList;
// Pour Save/Restore des attributs graphiques 
  PIColors  sFCol, sBCol;
  PIGOMode sGOm;
  PIFontAtt sFAtt;
  PILineAtt sLAtt;
  int sFSize;
  PIMarker sMrk;
  int sMrkSz;

};


#endif /* PIBWDGGEN_H_SEEN */

