/* Widget Xt pour affichage d'image  Interface Public    */
/*                                    Reza 10/95         */

#ifndef PIBWDGMAC_H_SEEN
#define PIBWDGMAC_H_SEEN

#include "pisysdep.h"
#include "pibwdggen.h"


class PIBaseWdgMac : public PIBaseWdgGen
{
public:
// Les methodes ...

                     PIBaseWdgMac(PIContainerGen *par, char *nom,
                                   int sx=10, int sy=10, int px=0, int py=0);
  virtual           ~PIBaseWdgMac();

//  Activation des evenements   
  virtual void       ActivatePtrCross();
  virtual void       ActivateButton(int bid);
  virtual void       ActivateMove(int bid);
  virtual void       ActivateKeyboard();

//  Trace graphiques
  virtual void       EraseWindow(int x0=0, int y0=0, int dx=0, int dy=0);
  virtual void       DrawString(int x, int y, char* s, int pos = 0);
  virtual void       DrawLine(int x1, int y1, int x2, int y2);
  virtual void       DrawBox(int x0, int y0, int dx, int dy);
  virtual void       DrawFBox(int x0, int y0, int dx, int dy);
  virtual void       DrawCircle(int x0, int y0, int r);
  virtual void       DrawFCircle(int x0, int y0, int r);
  virtual void       DrawPolygon(int *x, int *y, int n);  
  virtual void       DrawFPolygon(int *x, int *y, int n);  
  virtual void       DrawMarker(int x0, int y0);
  virtual void       DrawMarkers(int *x, int *y, int n);

  virtual int        CalcStringWidth(char const* s);  
  
  virtual void       SelForeground(PIColors col=PI_White);
  virtual void       SelBackground(PIColors col=PI_Black);
  virtual void       SelGOMode(PIGOMode mod=PI_GOCopy);
  virtual void       SelFont(PIFontSize sz=PI_NormalSizeFont, 
                             PIFontAtt att=PI_RomanFont);
  virtual void       SelFontSzPt(int npt=12, PIFontAtt att=PI_RomanFont); 
  virtual void       SelLine(PILineAtt att=PI_NormalLine);
  virtual void       SelPointerShape(PIPointer ptr=PI_ArrowPointer);
  virtual void       SelMarker(int msz, PIMarker mrk=PI_DotMarker);


// Acces aux attributs graphiques 
  virtual PIColors   GetForeground();
  virtual PIColors   GetBackground();
  virtual PIGOMode   GetGOMode();
  virtual PIFontAtt  GetFontAtt();
  virtual int        GetFontSize();
  virtual PILineAtt  GetLineAtt();
  virtual PIPointer  GetPointerShape();
  virtual PIMarker   GetMarker();
  virtual int        GetMarkerSize();

//  Fonction qui doit etre appelee pour rafraichir (retracer) tout 
  virtual void       Refresh();

// Traitement des evenements   
  virtual void       Resize();
  virtual void       Draw();
  virtual void       Draw(int x0, int y0, int dx, int dy);


protected:
  friend class       PIUpdAttachment;
  virtual bool       AdjustCursor();
  void               LocalToMacPortPoint(int x, int y, int& xm, int& ym);
  CursPtr            cursor;
  
  PolyHandle         MakePoly(int *x, int *y, int n);

  PIColors  mFCol, mBCol;
  PIGOMode  mGOm;
  PIPointer mPtrS;
  PIFontAtt mFAtt;
  PILineAtt mLAtt;
  int       mFSize;
  PIMarker  mMrk;
  int       mMrkSz;
};

typedef PIBaseWdgMac PIBaseWdg;

#endif /* RZXBASE_H_SEEN */
