#include "pidrawer.h"
#include "psfile.h"

PIDrawer::PIDrawer()
{
  mBWdg = NULL; 
  xW0 = yW0 = 0; xWd = yWd = 100; 
  aXdir = false;  // Vrai si Axe X de Droite vers Gauche 
  aYdir = false;  // Vrai si Axe Y de Haut vers Bas
  SetLimits(-1, 1, -1, 1, kAxeDirLtoR, kAxeDirDownUp);
  limitsFixed = 0;
  SetAxesFlags(kAxesDflt);
  clip = true;  
  mDndfg = false;  // Pour controle de l'appel de Detach() si delete
}

PIDrawer::~PIDrawer()
{
  list<DrwBWId>::iterator it;
  mDndfg = true;
  for(it = mBWdgList.begin(); it != mBWdgList.end(); it++)
         (*it).wdg->RemoveDrawer((*it).id);
}


void
PIDrawer::SetLimits(double xmin, double xmax, double ymin, double ymax,
                    int axrl, int ayud)
{
  if (xmax <= xmin || ymax <= ymin)
    return; // $CHECK$ exception ?
  if (axrl == kAxeDirLtoR)  aXdir = false;
  else if (axrl == kAxeDirRtoL)  aXdir = true;
  if (ayud == kAxeDirDownUp)  aYdir = false;
  else if (ayud == kAxeDirUpDown)  aYdir = true;
  xMin = xmin;
  xMax = xmax;
  yMin = ymin;
  yMax = ymax;
  SetDrwWdg(mBWdg, xW0, yW0, xWd, yWd);
  CalcTicks();
  limitsFixed = 1;
}

void
PIDrawer::Attach(PIBaseWdgGen* wdg, int id)
{
  if (!wdg) return;
  DrwBWId bwi;
  bwi.id = id;  bwi.wdg = wdg;
  mBWdgList.push_back(bwi);
  return;
}

void
PIDrawer::Detach(PIBaseWdgGen* wdg, int id)
{
  if (mDndfg) return;
  if (!wdg) return;
  list<DrwBWId>::iterator it;
  for(it = mBWdgList.begin(); it != mBWdgList.end(); it++)
     if ( ((*it).id == id) && ((*it).wdg == wdg) ) { mBWdgList.erase(it);  break; }
  return;
}


void
PIDrawer::SetDrwWdg(PIBaseWdgGen* drw, int x0, int y0, int dx, int dy)
{
  mBWdg = drw;
  xW0 = x0;   yW0 = y0;
  xWd = dx;   yWd = dy;
  xScale = (double)dx/(xMax-xMin);
  if (aXdir)  { 
    xScale = -xScale;
    xOrg   = -xMax * xScale;
  }
  else xOrg   = -xMin * xScale;
  xOrg += xW0;

  yScale = (double)dy/(yMax-yMin);
  if (!aYdir) {
    yScale = -yScale;
    yOrg   = -yMax  * yScale;
    }
  else yOrg   = -yMin * yScale;
  yOrg += yW0;
  return;
}


void
PIDrawer::CalcTicks()
{
	double xExt = xMax-xMin;
	int lx = (int) ceil(log10(xExt)-0.1);
	xExt = pow(10.0,lx);
	xMajTickStep = xExt/10;
	xMinTickStep = xMajTickStep/10;
    xFirstMajTick = int(xMin / xMajTickStep) * xMajTickStep;
    if (xFirstMajTick < xMin) xFirstMajTick += xMajTickStep;
    xFirstMinTick = int(xMin / xMinTickStep) * xMinTickStep;
    if (xFirstMinTick < xMin) xFirstMinTick += xMinTickStep;
    
    
	double yExt = yMax-yMin;
	int ly = (int) ceil(log10(yExt)-0.1);
	yExt = pow(10.0,ly);
	yMajTickStep = yExt/10;
	yMinTickStep = yMajTickStep/10;
    yFirstMajTick = int(yMin / yMajTickStep) * yMajTickStep;
    if (yFirstMajTick < yMin) yFirstMajTick += yMajTickStep;
    yFirstMinTick = int(yMin / yMinTickStep) * yMinTickStep;
    if (yFirstMinTick < yMin) yFirstMinTick += yMinTickStep;
    
    yMajTickLen = (xMax-xMin)/100;
    yMinTickLen = (xMax-xMin)/250;
    xMajTickLen = (yMax-yMin)/100;
    xMinTickLen = (yMax-yMin)/250;

}

void
PIDrawer::Sc2Local(double x, double y, int& xpix, int& ypix)
{
  xpix = int(xOrg + x*xScale + .5);
  ypix = int(yOrg + y*yScale + .5);
}

void
PIDrawer::Sc2LocalF(double x, double y, float& xpix, float& ypix)
{
  xpix = (float)(xOrg + x*xScale + .5);
  ypix = (float)(yOrg + y*yScale + .5);
}

void
PIDrawer::Local2Sc(int xpix, int ypix, double& x, double& y)
{
  x = (xpix-xOrg)/xScale;
  y = (ypix-yOrg)/yScale;
}


void
PIDrawer::DSc2Local(double dx, double dy, int& dxpix, int& dypix)
{
  dxpix = int(dx*xScale + .5);
  if (dxpix < 0)  dxpix = -dxpix;
  dypix = int(dy*yScale + .5);
  if (dypix < 0)  dypix = -dxpix;
}


void
PIDrawer::Erase()
{
  if (!mBWdg) return;
  mBWdg->EraseWindow(xW0, yW0, xWd, yWd);
}

void
PIDrawer::DrawString(double x, double y, char* s, int pos)
{
  if (!mBWdg) return;
  if (mBWdg->mPSOut) {
    float xf, yf;
    Sc2LocalF(x, y, xf, yf);
    (mBWdg->mPSOut)->DrawString(xf,yf,s, mBWdg->GetForeground(), /* $CHECK$ PIFontSize ?? */
                                mBWdg->GetFontAtt(),  mBWdg->GetFontSize()); 
  }
  else {
    int xPix, yPix;
    Sc2Local(x, y, xPix, yPix);
    mBWdg->DrawString(xPix, yPix, s, pos);
  }
}

void
PIDrawer::DrawLine(double x1, double y1, double x2, double y2)
{
  
  if (!mBWdg) return;
  if (clip) {
    if (x2 < xMin && x1 < xMin) return;
    if (x2 > xMax && x1 > xMax) return;
    if (y1 < yMin && y2 < yMin) return;
    if (y1 > yMax && y2 > yMax) return;
    if (x2 < x1) {
      swap(x1,x2);
      swap(y1,y2);
    }
    if (x2>xMax) {
      y2 = y1 + (y2-y1)/(x2-x1)*(xMax-x1);
      x2 = xMax;
    }
    if (x1<xMin) {
      y1 = y2 + (y1-y2)/(x1-x2)*(xMin-x2);
      x1 = xMin;
    }
    if (y2 < y1) {
      swap(x1,x2);
      swap(y1,y2);
    }
    if (y2>yMax) {
      x2 = x1 + (x2-x1)/(y2-y1)*(yMax-y1);
      y2 = yMax;
    }
    if (y1<yMin) {
      x1 = x2 + (x1-x2)/(y1-y2)*(yMin-y2);
      y1 = yMin;
    }
  }

  if (mBWdg->mPSOut) {
    float xf1, yf1, xf2, yf2;
    Sc2LocalF(x1, y1, xf1, yf1);
    Sc2LocalF(x2, y2, xf2, yf2);
    (mBWdg->mPSOut)->DrawLine(xf1, yf1, xf2, yf2, mBWdg->GetForeground(), mBWdg->GetLineAtt());

    return;
  }
  
  int x1Pix, y1Pix, x2Pix, y2Pix;
  Sc2Local(x1, y1, x1Pix, y1Pix);
  Sc2Local(x2, y2, x2Pix, y2Pix);
  mBWdg->DrawLine(x1Pix, y1Pix, x2Pix, y2Pix);
}  


void
PIDrawer::DrawBox(double x, double y, double dx, double dy)
{
  if (!mBWdg) return;
  if (clip) {
    if (dx < 0) {
      x = x+dx;
      dx = -dx;
    }
    if (dy < 0) {
      y = y+dy;
      dy = -dy;
    }
    if (x > xMax || x+dx < xMin || y > yMax || y+dy < yMin) return;
    if (x < xMin) {
      dx -= (xMin-x);
      x = xMin;
    }
    if (y < yMin) {
      dy -= (yMin-y);
      y = yMin;
    }
    if (x+dx > xMax)
      dx = (xMax-x);
    if (y+dy > yMax)
      dy = (yMax-y);
  }

  if (mBWdg->mPSOut) {
    float xf, yf, xf2, yf2;
    Sc2LocalF(x, y, xf, yf);
    Sc2LocalF(x+dx, y+dy, xf2, yf2);
    if (xf2 < xf)  swap(xf, xf2);
    if (yf2 < yf)  swap(yf, yf2);
    (mBWdg->mPSOut)->DrawBox(xf, yf, xf2-xf, yf2-yf, mBWdg->GetForeground(), mBWdg->GetLineAtt() );
    return;
  }

  int xPix, yPix, x2Pix, y2Pix;
  Sc2Local(x, y, xPix, yPix);
  Sc2Local(x+dx, y+dy, x2Pix, y2Pix);
  if (x2Pix < xPix)  swap(xPix, x2Pix);
  if (y2Pix < yPix)  swap(yPix, y2Pix);
  mBWdg->DrawBox(xPix, yPix, x2Pix-xPix, y2Pix-yPix);
}  

void
PIDrawer::DrawFBox(double x, double y, double dx, double dy)
{

  if (!mBWdg) return;
  if (clip) {
    if (dx < 0) {
      x = x+dx;
      dx = -dx;
    }
    if (dy < 0) {
      y = y+dy;
      dy = -dy;
    }
    if (x > xMax || x+dx < xMin || y > yMax || y+dy < yMin) return;
    if (x < xMin) {
      dx -= (xMin-x);
      x = xMin;
    }
    if (y < yMin) {
      dy -= (yMin-y);
      y = yMin;
    }
    if (x+dx > xMax)
      dx = (xMax-x);
    if (y+dy > yMax)
      dy = (yMax-y);
  }

  if (mBWdg->mPSOut) {
    float xf, yf, xf2, yf2;
    Sc2LocalF(x, y, xf, yf);
    Sc2LocalF(x+dx, y+dy, xf2, yf2);
    if (xf2 < xf)  swap(xf, xf2);
    if (yf2 < yf)  swap(yf, yf2);
    (mBWdg->mPSOut)->DrawFBox(xf, yf, xf2-xf, yf2-yf, mBWdg->GetForeground(), 
                              mBWdg->GetForeground(), mBWdg->GetLineAtt());
    return;
  }

  int xPix, yPix, x2Pix, y2Pix;
  Sc2Local(x, y, xPix, yPix);
  Sc2Local(x+dx, y+dy, x2Pix, y2Pix);
  if (x2Pix < xPix)  swap(xPix, x2Pix);
  if (y2Pix < yPix)  swap(yPix, y2Pix);
  mBWdg->DrawFBox(xPix, yPix, x2Pix-xPix, y2Pix-yPix);
}  

void
PIDrawer::DrawCircle(double x, double y, double r)
{
  if (!mBWdg) return;
  if (mBWdg->mPSOut) {
    float xf, yf, rf;
    Sc2LocalF(x, y, xf, yf);
    rf = r * xScale;
    if (xScale < 0.)  rf = -rf;
    (mBWdg->mPSOut)->DrawCircle(xf, yf, rf,mBWdg->GetForeground(), mBWdg->GetLineAtt());
    return;
  }

  int xPix, yPix, rPix;
  Sc2Local(x, y, xPix, yPix);
  rPix = (int)(r * xScale);
  if (xScale < 0.)  rPix = -rPix;
  mBWdg->DrawCircle(xPix, yPix, rPix);
}  

void
PIDrawer::DrawFCircle(double x, double y, double r)
{
  if (!mBWdg) return;
  if (mBWdg->mPSOut) {
    float xf, yf, rf;
    Sc2LocalF(x, y, xf, yf);
    rf = r * xScale;
    if (xScale < 0.)  rf = -rf;
    (mBWdg->mPSOut)->DrawFCircle(xf, yf, rf, mBWdg->GetForeground(), 
                                 mBWdg->GetForeground(), mBWdg->GetLineAtt());
    return;
  }
  int xPix, yPix, rPix;
  Sc2Local(x, y, xPix, yPix);
  rPix = (int)(r * xScale);
  if (xScale < 0.)  rPix = -rPix;
  mBWdg->DrawFCircle(xPix, yPix, rPix);
}

#define NMXMULTP  30   // Pour multipoint sans new

void  
PIDrawer::DrawPolygon(double *x, double *y, int n)
{
int ix[NMXMULTP], iy[NMXMULTP];
int *pxi, *pyi;
int i;
 
if (!mBWdg) return;
if (n <= 0)  return;

if(mBWdg->mPSOut) {
  float *xf, *yf;
  xf = new float[n];
  yf = new float[n];
  for(i=0;i<n;i++)
    Sc2LocalF(x[i], y[i], xf[i], yf[i]);
    (mBWdg->mPSOut)->DrawPolygon(xf,yf,n, mBWdg->GetForeground(), mBWdg->GetLineAtt());
  delete[] xf;
  delete[] yf;
  return;
  }

if (n > NMXMULTP) { pxi = new int[n];  pyi = new int[n]; }
else { pxi = ix;  pyi = iy; }
for(i=0; i<n; i++)  
  Sc2Local(x[i], y[i], pxi[i], pyi[i]);
mBWdg->DrawPolygon(pxi, pyi, n);
if (n > NMXMULTP) { delete[] pxi;  delete[] pyi; }
return;
}
  
void  
PIDrawer::DrawFPolygon(double *x, double *y, int n)
{
int xi[NMXMULTP], yi[NMXMULTP];
int *pxi, *pyi;
int i;
 
if (!mBWdg) return;
if (n <= 0)  return;

if(mBWdg->mPSOut) {
  float *xf, *yf;
  xf = new float[n];
  yf = new float[n];
  for(i=0;i<n;i++)
    Sc2LocalF(x[i], y[i], xf[i], yf[i]);
    (mBWdg->mPSOut)->DrawFPolygon(xf, yf, n, mBWdg->GetForeground(), 
                                  mBWdg->GetForeground(), mBWdg->GetLineAtt());
  delete[] xf;
  delete[] yf;
  return;
  }

if (n > NMXMULTP) { pxi = new int[n];  pyi = new int[n]; }
else { pxi = xi;  pyi = yi; }
for(i=0; i<n; i++)  
  Sc2Local(x[i], y[i], pxi[i], pyi[i]);
mBWdg->DrawFPolygon(pxi, pyi, n);
if (n > NMXMULTP) { delete[] pxi;  delete[] pyi; }
return;
}

void  
PIDrawer::DrawMarker(double x0, double y0)
{
  if (!mBWdg) return;
  if(mBWdg->mPSOut) {
    float xf, yf;
    Sc2LocalF(x0, y0, xf, yf);
    (mBWdg->mPSOut)->DrawMarker(xf, yf, mBWdg->GetMarker(), 
                                mBWdg->GetForeground(), mBWdg->GetMarkerSize() );
    return;    
  }
  int xPix, yPix;
  Sc2Local(x0, y0, xPix, yPix);
  mBWdg->DrawMarker(xPix, yPix);
  return;
}

void  
PIDrawer::DrawMarkers(double *x, double *y, int n)
{
int xi[NMXMULTP], yi[NMXMULTP];
int *pxi, *pyi;
int i;
 
if (!mBWdg) return;
if (n <= 0)  return;

if(mBWdg->mPSOut) {
  float *xf, *yf;
  xf = new float[n];
  yf = new float[n];
  for(i=0;i<n;i++)
    Sc2LocalF(x[i], y[i], xf[i], yf[i]);

  (mBWdg->mPSOut)->DrawMarkers(xf, yf, n, mBWdg->GetMarker(), 
                               mBWdg->GetForeground(), mBWdg->GetMarkerSize() );
  delete[] xf;
  delete[] yf;
  return;
  }

if (n > NMXMULTP) { pxi = new int[n];  pyi = new int[n]; }
else { pxi = xi;  pyi = yi; }
for(i=0; i<n; i++)  
  Sc2Local(x[i], y[i], pxi[i], pyi[i]);
mBWdg->DrawMarkers(pxi, pyi, n);
if (n > NMXMULTP) { delete[] pxi;  delete[] pyi; }
return;
}

void  
PIDrawer::DrawPixmap(double x, double y, unsigned char *pix,
                          int sx, int sy, PIColorMap* cmap)
{
  if (!mBWdg) return;
  if ( (sx < 1) || (sy < 1) )  return;
  if ((pix == NULL) || (cmap == NULL)) return; 

  if(mBWdg->mPSOut) {
    float xf,yf;
    Sc2LocalF(x, y, xf, yf);
    (mBWdg->mPSOut)->Image(xf, yf, (float)sx, (float)sy, sx, sy, pix, cmap);
    return;
    }

  int xPix, yPix;
  Sc2Local(x, y, xPix, yPix);
  mBWdg->DrawPixmap(xPix, yPix, pix, sx, sy, cmap);
}

double
PIDrawer::StringWidth(char const* s)
{
  if (!mBWdg) return(0.);
  return mBWdg->CalcStringWidth(s) / xScale;
}

double
PIDrawer::FontHeight(double& asc, double& desc)
{
  if (!mBWdg) return(0.);
  int h,a,d;
  h = mBWdg->GetFontHeight(a,d);
  asc = (double)a / yScale;
  desc = (double)d / yScale;
  return((double)h / yScale);
}


void
PIDrawer::SelForeground(PIColors col)
{
  if (!mBWdg) return;
  mBWdg->SelForeground(col);
  return;  
}


void
PIDrawer::SelBackground(PIColors col)
{
  if (!mBWdg) return;
  mBWdg->SelBackground(col);
  return;  
}

void
PIDrawer::SelGOMode(PIGOMode mod)
{
  if (!mBWdg) return;
  mBWdg->SelGOMode(mod);
  return;  
}

void
PIDrawer::SelFont(PIFontSize sz, PIFontAtt att)
{
  if (!mBWdg) return;
  mBWdg->SelFont(sz, att);
  return;  
}

void
PIDrawer::SelLine(PILineAtt att)
{
  if (!mBWdg) return;
  mBWdg->SelLine(att);
  return;  
}


void
PIDrawer::SelFontSz(double size, PIFontAtt att)
{
  if (!mBWdg) return;
  int npt = int(fabs(size * yScale)+.5);
  if (npt < 8) npt = 8;
  if (npt > 127) npt = 127;
  mBWdg->SelFontSzPt(npt, att);
}

void
PIDrawer::SelMarker(double size, PIMarker mrk)
{
  if (!mBWdg) return;
  int isz = int(fabs(size * xScale)+.5);
  mBWdg->SelMarker( isz, mrk);
}

void
PIDrawer::SelMarker(int msz, PIMarker mrk)
{
  if (!mBWdg) return;
  mBWdg->SelMarker( msz, mrk);
}



void
PIDrawer::SetAxesFlags(int flags)
{
  axesFlags = flags;
  if (axesFlags & (kIntTicks | kExtTicks | kMajTicks | kMinTicks))
    axesFlags |= kTicks;
  if ((axesFlags & (kTicks | kIntTicks | kExtTicks)) == kTicks)
    axesFlags |= kIntTicks | kExtTicks;
  if ((axesFlags & (kTicks | kMajTicks | kMinTicks)) == kTicks)
    axesFlags |= kMajTicks;
}


void
PIDrawer::DrawAxes(int flags)
{
  NoClip();
  if (flags == -1)
    flags = axesFlags;
    
  
  if (flags & kStdAxes) {
  
    // Les axes
    
    DrawLine(xMin, 0, xMax, 0);
    DrawLine(0, yMin, 0, yMax);
  
    // Les ticks majeurs
  
    if (flags & kMajTicks) {
        DrawHTicks(0, xMajTickLen, xMajTickLen, xFirstMajTick, xMajTickStep);
        DrawVTicks(0, yMajTickLen, yMajTickLen, yFirstMajTick, yMajTickStep);
    }
    
    // Les ticks mineurs
  
    if (flags & kMinTicks) {
        DrawHTicks(0, xMinTickLen, xMinTickLen, xFirstMinTick, xMinTickStep);
        DrawVTicks(0, yMinTickLen, yMinTickLen, yFirstMinTick, yMinTickStep);
    }
    
    // Les labels
    
    if (flags & kLabels) {
      if (!aYdir)
        DrawHLabels(-xMajTickLen*8, xFirstMajTick, xMajTickStep,0);
      else 
        DrawHLabels(xMajTickLen*8, xFirstMajTick, xMajTickStep,0);
      if (!aXdir)
        DrawVLabels(-yMajTickLen*2, yFirstMajTick, yMajTickStep,1);
      else 
        DrawVLabels(yMajTickLen*2, yFirstMajTick, yMajTickStep,1);
    }
    
  }
  
  if (flags & kBoxAxes) {
  
    // La boite
    
    DrawLine(xMin, yMin, xMax, yMin);
    DrawLine(xMax, yMin, xMax, yMax);
    DrawLine(xMax, yMax, xMin, yMax);
    DrawLine(xMin, yMax, xMin, yMin);

    // Longueur des ticks
    
    double extXMajTickLen = flags&kExtTicks ? xMajTickLen : 0;
    double intXMajTickLen = flags&kIntTicks ? xMajTickLen : 0;
    double extXMinTickLen = flags&kExtTicks ? xMinTickLen : 0;
    double intXMinTickLen = flags&kIntTicks ? xMinTickLen : 0;
    double extYMajTickLen = flags&kExtTicks ? yMajTickLen : 0;
    double intYMajTickLen = flags&kIntTicks ? yMajTickLen : 0;
    double extYMinTickLen = flags&kExtTicks ? yMinTickLen : 0;
    double intYMinTickLen = flags&kIntTicks ? yMinTickLen : 0;

    // Les ticks majeurs
  
    if (flags & kMajTicks) {
        DrawHTicks(yMin, intXMajTickLen, extXMajTickLen, xFirstMajTick, xMajTickStep);
        DrawHTicks(yMax, extXMajTickLen, intXMajTickLen, xFirstMajTick, xMajTickStep);
        DrawVTicks(xMin, extYMajTickLen, intYMajTickLen, yFirstMajTick, yMajTickStep);
        DrawVTicks(xMax, intYMajTickLen, extYMajTickLen, yFirstMajTick, yMajTickStep);
    }
    
    // Les ticks mineurs
  
    if (flags & kMinTicks) {
        DrawHTicks(yMin, intXMinTickLen, extXMinTickLen, xFirstMinTick, xMinTickStep);
        DrawHTicks(yMax, extXMinTickLen, intXMinTickLen, xFirstMinTick, xMinTickStep);
        DrawVTicks(xMin, extYMinTickLen, intYMinTickLen, yFirstMinTick, yMinTickStep);
        DrawVTicks(xMax, intYMinTickLen, extYMinTickLen, yFirstMinTick, yMinTickStep);
    }


    // Les labels
    
    if (flags & kLabels) {
      if (!aYdir) {
        DrawHLabels(yMin-xMajTickLen*8, xFirstMajTick, xMajTickStep,0);
        DrawHLabels(yMax+xMajTickLen*2, xFirstMajTick, xMajTickStep,0);
      }
      else {
        DrawHLabels(yMin-xMajTickLen*2, xFirstMajTick, xMajTickStep,0);
        DrawHLabels(yMax+xMajTickLen*8, xFirstMajTick, xMajTickStep,0);
      }
      if (!aXdir) {
        DrawVLabels(xMin-yMajTickLen*2, yFirstMajTick, yMajTickStep,1);
        DrawVLabels(xMax+yMajTickLen*2, yFirstMajTick, yMajTickStep,-1);
      }
      else {
        DrawVLabels(xMin-yMajTickLen*2, yFirstMajTick, yMajTickStep,-1);
        DrawVLabels(xMax+yMajTickLen*2, yFirstMajTick, yMajTickStep,1);
      }
    }
  }
  Clip();
}

  
void
PIDrawer::Draw()
{
}

void
PIDrawer::Draw(double /*xmin*/, double /*ymin*/, double /*xmax*/, double /*ymax*/)
{
Draw();
}


void
PIDrawer::DrawHTicks(double y, double tickUp, double tickDown, double xBeg, double xStep)
{
  for (double x=xBeg; x<=xMax; x += xStep)
    DrawLine(x, y-tickDown, x, y+tickUp);
}

void
PIDrawer::DrawVTicks(double x, double tickLeft, double tickRight, double yBeg, double yStep)
{
  for (double y=yBeg; y<=yMax; y += yStep)
    DrawLine(x-tickLeft, y, x+tickRight, y);
}

void
PIDrawer::DrawHLabels(double y, double xBeg, double xStep, int just)
{
  double xOffset = 0;
  int kk;
  SelFontSz(xMajTickLen*4.);
  for (double x=xBeg; x<=xMax; x += xStep) {
      char label[20]; sprintf(label, "%-6g", x);
      for(kk=0; kk<20; kk++)
        if (label[kk] == ' ')   { label[kk] = '\0' ; break; }
      double largeur = StringWidth(label);
      if (just == 1)
        xOffset = -largeur;
      else if (just == 0)
        xOffset = -largeur/2;
      else
        xOffset = 0;
      if (aXdir)  xOffset = -xOffset;
      DrawString(x+xOffset, y, label);
  }
}

void
PIDrawer::DrawVLabels(double x, double yBeg, double yStep, int just)
{
  double xOffset = 0;
  SelFontSz(xMajTickLen*4.);
  for (double y=yBeg; y<=yMax; y += yStep) {
      char label[20]; sprintf(label, "%-6g", y);
      double largeur = StringWidth(label);
      if (just == 1)
        xOffset = -largeur;
      else if (just == 0)
        xOffset = -largeur/2;
      else
        xOffset = 0;
      if (aXdir)  xOffset = -xOffset;
      DrawString(x+xOffset, y, label);
  }
}

