#include "spherepos.h"

static char *head_spherepos_cc_ = "$Header: /Users/garnier/temp/CVSSophya/SophyaLib/Samba/spherepos.cc,v 1.2 1999-10-27 10:45:47 ansari Exp $";


//................. SphereCoordSys class .................

SphereCoordSys::SphereCoordSys(){
  id_ = SphereCoordSys_NEUTRAL;
  description_ = "NEUTRAL SphereCoordSystem";
}

SphereCoordSys::SphereCoordSys(int id, const string& description){
  id_ = id;
  description_ = description;
}

SphereCoordSys::~SphereCoordSys()
{
}

// Temporary implementation of PPersist::
// To be changed later ($CHECK$  Reza 26/10/99) 
void SphereCoordSys::ReadSelf(PInPersist& is)
{
uint_8 itab[3];
is.Get(itab, 3);
id_ = itab[1];
is.GetStr(description_);
}

void SphereCoordSys::WriteSelf(POutPersist& os) const
{
//  On ecrit 3 uint_8 
//  0 : Numero de version,  1 : Id,  2  reserve a l
uint_8 itab[3];
itab[0] = 1;
itab[1] = id_;
itab[2] = 0;
os.Put(itab, 3);
os.PutStr(description_);
}

//................. SpherePosition class .................

SpherePosition::SpherePosition() 
        : UnitVector()
{
  cs_ = new SphereCoordSys;
}

SpherePosition::SpherePosition(double theta, double phi, SphereCoordSys* cs)
        : UnitVector(theta, phi)
{
if (cs == NULL) cs_ = new SphereCoordSys;
else cs_ = cs;
}

SpherePosition::SpherePosition(double x, double y, double z, SphereCoordSys* cs)
        : UnitVector(x, y, z)
{
if (cs == NULL) cs_ = new SphereCoordSys;
else cs_ = cs;
}

SpherePosition::~SpherePosition()
{
if (cs_) delete cs_;
}

UnitVector SpherePosition::Transform(const SphereCoordSys& cs) const
{
return(*this);
}

double SpherePosition::Separation(const SpherePosition& gamma) const 
{
return(this->SepAngle(gamma));
}
