// This may look like C code, but it is really -*- C++ -*-
#ifndef TOD_H_SEEN
#define TOD_H_SEEN

#include "machdefs.h"
#include "spherepos.h"
#include "misstime.h"

namespace PlanckDPC {
template<class T>
class TOD 
{
public:
		TOD(SphereCoordSys* cs = NULL)
                    { if (cs) cs_ = cs; else cs = new SphereCoordSys; }
  virtual 	~TOD()
                    { if (cs_) delete cs_; }

// Set/Change/Get the coordinate system
  virtual void  SetCoordSys(SphereCoordSys* cs)
                    { if (cs) { delete cs_;  cs_ = cs; } }
  inline SphereCoordSys* GetCoordSys() const { return(cs_); }

// Return the size / number of sample
  virtual int_8 size() const = 0; 
  inline  int_8 NbSample() const { return(size()); }

// Start/End time
  virtual MissionTime StartTime();
  virtual MissionTime EndTime();

// Sample time 
  virtual const MissionTime& SampleTime() const = 0;
  virtual MissionTime& SampleTime() = 0;

// Sample value
  virtual const T& SampleValue() const = 0;
  virtual T& SampleValue() = 0;

// Sample direction
  virtual const UnitVector& SamplePointing() const = 0;
  virtual UnitVector& SamplePointing() = 0;

};

} // Fin du namespace

#endif
