// archtoi.cc
// Eric Aubourg         CEA/DAPNIA/SPP   juillet 1999


#include <string>
#include <iostream.h>
#include <fstream.h>
#include <iomanip.h>

#include "archeopsfile.h"
#include "toiiter.h"
#include "toimanager.h"
#include "archtoi.h"
#include "archparam.h"
#include "archvers.h"

using namespace std; 

#ifdef __MWERKS__
#include "Events.h"
#include "LowMem.h"
#include "sioux.h"
static int macSleepTicks = 0;
static int macRunTicks = 10;
static void yield()
{
    EventRecord theEvent;
    static long int macLastTicks;
    long int ticks = LMGetTicks();
    if (ticks - macLastTicks >= macRunTicks) {
      if (WaitNextEvent(everyEvent, &theEvent,macSleepTicks,0))
        SIOUXHandleOneEvent(&theEvent);
      macLastTicks = LMGetTicks();
    }
}
#endif


ArchTOI::ArchTOI(istream& str)
{
  init();
  iter.readReq(str);
}


ArchTOI::ArchTOI(string const& filename)
{
  init();
  ifstream str(filename.c_str());
  iter.readReq(str);
}

void ArchTOI::init()
{
  format = ascii_fmt;
  undef  = "#";
  undefV = -99999;
  allBolos = false;
  fptr = NULL;
  ostr = NULL;
  requestVersion = "";
  iter.registerReqHandler(this);
  
  TOIManager::registerDefaultProducers();
}


bool ArchTOI::processTOIReq(TOI const& toi, string line)
{
  headertoi.push_back(line);
  tois.push_back(toi);
  return true;
} 

bool ArchTOI::processOption(string key, string arg)
{
  string line=key; if (arg != "") line = line + " " + arg;
  headeropt.push_back(line);
  if (arg.length()>0 && arg[0] == ' ') {
    arg = arg.substr(arg.find_first_not_of(' '));
  }
  if (key == "#ASCII") {
    format = ascii_fmt;
  } else if (key == "#FITS") {
    format = fits_fmt;
  } else if (key == "#UNDEF") {
    undef=arg;
    if (undef[0] >= '0' && undef[0] <= '9')
      undefV = atoi(undef.c_str());
  } else if (key == "#ALLBOLOS") {
    allBolos=true;
  } else if (key == "#REQVERSION") {
    if (requestVersion != "") {
      cerr << "Error. Duplicate #REQVERSION option" << endl;
      exit(-1);
    }
    requestVersion = arg;
  } else if (key == "#COMMENT") {
    comments.push_back(arg);
  } else {
    return false;
  }
  
  return true;
}


void ArchTOI::run(string const& outfilename)
{
  if (format == ascii_fmt) {
    openFile   = &openFile_A;
    outHeader  = &outHeader_A;
    outValue   = &outValue_A;
    endLine    = &endLine_A;
    closeFile  = &closeFile_A;
  } else { // fits_fmt 
    openFile   = &openFile_F;
    outHeader  = &outHeader_F;
    outValue   = &outValue_F;
    endLine    = &endLine_F;
    closeFile  = &closeFile_F;
  }
  
  cout << "starting query" << endl;
  iter.init();
  (this->*openFile)(outfilename);
  (this->*outHeader)(iter);
  
  cout << "processing" << endl;
  while (iter.next()) {
    int nn = iter.getSampleNum() / iter.getUnderSample(); // Only for tick mark...
    #ifdef __MWERKS__
    yield();
    #endif
     if (nn%200 == 0) {
       cout << "."; cout.flush();
     }
     if (nn%(200*80) == 0) cout << endl;
    // Si rien de dispo parmi les triggering, alors on passe au suivant
    // normalement, c'est gere par le toiiter...
    //bool hasValue = false;
    //for (int i=0; i<toiflags.size(); i++) {
    //   if (!iter.isTrig(i)) continue;
    //   if (iter.canGetValue(i)) {hasValue=true; break;}
    //}
    //if (!hasValue) continue;
    int icol=0;
    for (int i=0; i<tois.size(); i++) {
      double value = iter.getValue(i);
      bool   ok    = iter.canGetValue(i);
     // bool   isnew = iter.newValue(i);
     // flg    flag  = toiflags[i];
     // if (flag & hasflag) {
     //   (this->*outValue)(icol,  (ok && isnew ? 1 : 0));
     //   icol++;
     // }
     //if (((flag & useNA)!=0 && !isnew) || !ok) 
      if (!ok) 
        (this->*outValue)(icol,  0, true);
      else
        (this->*outValue)(icol, value);
      icol++;
    }
    (this->*endLine)();
  }
  (this->*closeFile)();
  cout << "\nDone." << endl;
}


void ArchTOI::openFile_A(string const& filename) {
  ostr = new ofstream(filename.c_str());
}

void ArchTOI::outHeader_A(TOIIter& iter) {
  if (!ostr) return;
  for (list<string>::iterator i = headertoi.begin(); i != headertoi.end(); i++)
    *ostr << (*i) << '\n';
  for (list<string>::iterator i = headeropt.begin(); i != headeropt.end(); i++)
    *ostr << (*i) << '\n';;
  block_type_param* blk = iter.getFSet().lastParam();
  if (blk) {
    int nb = blk->param.n_max_bolo;
    for (int i=0; i<nb; i++) {
#if version_num > 25
      if (allBolos) {
        *ostr << "$BOLO " << i << " " 
            << blk->param.nom_coef[blk->param.bolo[i].numero_nom_coef].bolo_nom << " " 
            << blk->param.bolo[i].bolo_code_util << '\n';
      } else if (blk->param.bolo[i].bolo_code_util != bolo_hors_service &&
                 blk->param.bolo[i].bolo_code_util != bolo_normal_non_transmis) {
        *ostr << "$BOLO " << i << " " 
            << blk->param.nom_coef[blk->param.bolo[i].numero_nom_coef].bolo_nom << "\n";
      }
#else
      *ostr << "$BOLO " << i << " " << 
        blk->param.bolo[i].bolo_nom << '\n';
#endif
    }
  }
  *ostr << "#END" << endl;
}

void ArchTOI::outValue_A(int icolumn, double value, bool notdef) {
  if (!ostr) return;
  if (icolumn > 0) *ostr << '\t';
  if (notdef) {
     *ostr << undef ;
  } else {
     *ostr << setprecision(11) << value ;
  }
}

void ArchTOI::endLine_A() {
  if (!ostr) return;
  *ostr << '\n';
}

void ArchTOI::closeFile_A() {
  delete ostr;
  ostr = NULL;
}

list<string> ArchTOI::buildNames() {
  list<string> toinames;
  map<string,int> namecount;
  
  for (list<TOI>::iterator i = tois.begin(); i != tois.end(); i++) {
    namecount[(*i).name]++;
  }
  
  map<string,int> curcount;
  for (list<TOI>::iterator i = tois.begin(); i != tois.end(); i++) {
    string toiname = (*i).name;
    if (namecount[(*i).name]>1) {
      char s[10];
      sprintf(s,"_%d",curcount[(*i).name]++);
      toiname += s;
    }
    if ((*i).index != TOI::unspec) {
      char s[10];
      sprintf(s,"_%d",(*i).index);
      toiname += s;
    }
    toinames.push_back(toiname);
  }
  return toinames;
}

void ArchTOI::openFile_F(string const& filename) {
  fitsStatus=0;
  remove(filename.c_str());
  if (fits_create_file(&fptr, filename.c_str(), &fitsStatus)) {
    fits_report_error(stderr, fitsStatus);
    exit(-1);
  }
}


void ArchTOI::outHeader_F(TOIIter& iter) {  
  list<string> toinames = buildNames();

  int ncols=toinames.size();
  
  char** colnames = new (char*[ncols]);
  char** coltypes = new (char*[ncols]);
  char** colunits = new (char*[ncols]);
  int j=0;
  list<TOI>::iterator kk = tois.begin();
  for (list<string>::iterator i = toinames.begin(); i != toinames.end(); i++,j++,kk++) {
    colnames[j] = const_cast<char*>((*i).c_str()); // should work for most STL implementations... Check...
    coltypes[j] = "1D";
    colunits[j] = const_cast<char*>((*kk).unit.c_str());
    cout << (*i).c_str() << " " << ((*kk).unit.c_str()) << endl;
  }
  
  fits_create_tbl(fptr, BINARY_TBL, 0, ncols, colnames, coltypes, colunits, NULL, &fitsStatus);
  fits_write_date(fptr, &fitsStatus);

  delete[] colunits;
  delete[] coltypes;
  delete[] colnames;

  j=1;
  // Rappel dans le header des requetes...
  int ntoireq = headertoi.size();
  fits_write_key(fptr, TINT, "TOIREQ", &ntoireq, NULL, &fitsStatus);
  list<string>::iterator kkk = toinames.begin();
  for (list<string>::iterator i = headertoi.begin(); i != headertoi.end(); i++,j++,kkk++) {
    char line[80];
    strcpy(line, (*i).c_str());
    char* pline = line;
    char* cmt   = const_cast<char*>((*kkk).c_str());
    fits_write_keys_str(fptr, "TOIREQ", j, 1, &pline, &cmt, &fitsStatus);
  }
  j=1;
  int noptreq = headeropt.size();
  fits_write_key(fptr, TINT, "OPTREQ", &noptreq, NULL, &fitsStatus);
  for (list<string>::iterator i = headeropt.begin(); i != headeropt.end(); i++,j++) {
    char line[80];
    strcpy(line, (*i).c_str());
    char* pline = line;
    fits_write_keys_str(fptr, "OPTREQ", j, 1, &pline, (char**) NULL, &fitsStatus);
  }

  // Noms des bolos
  block_type_param* blk = iter.getFSet().lastParam();
  if (blk) {
    int nb = blk->param.n_max_bolo;
    j=0;
    for (int i=0; i<nb; i++) {
#if version_num > 25
      if (allBolos || 
           (blk->param.bolo[i].bolo_code_util != bolo_hors_service &&
            blk->param.bolo[i].bolo_code_util != bolo_normal_non_transmis)) {
        //j++;
        char line[80];
        strcpy(line, blk->param.nom_coef[blk->param.bolo[i].numero_nom_coef].bolo_nom);
        char* pline = line;
        fits_write_keys_str(fptr, "BOLO", i, 1, &pline, (char**) NULL, &fitsStatus);
      }
#else
        //j++;
        char line[80];
        strcpy(line, blk->param.bolo[i].bolo_nom);
        char* pline = line;
        fits_write_keys_str(fptr, "BOLO", i, 1, &pline, (char**) NULL, &fitsStatus);
#endif
    }
    //fits_write_key(fptr, TINT, "BOLO", &j, NULL, &fitsStatus);
  }
  fits_write_key_str(fptr, "TOIVERS", ARCHTOI_VERS, "Archtoi version",&fitsStatus);
  fits_write_key_str(fptr, "TOITAG", ARCHTOI_TAG, "Archtoi cvs tag",&fitsStatus);
  if (requestVersion != "")
    fits_write_key_str(fptr, "REQVERS", (char*) requestVersion.c_str(), 
                       "Request options version",&fitsStatus);
  fits_write_comment(fptr, "Generated with archtoi " ARCHTOI_VERS, &fitsStatus);
  char line[80];
  sprintf(line, "using archeops.h %d", version_num);
  fits_write_comment(fptr, line, &fitsStatus);
  for (list<string>::iterator i = comments.begin(); i!=comments.end(); i++)
    fits_write_comment(fptr, (char*)((*i).c_str()), &fitsStatus);
  
  fitsLine = 1;
}

void ArchTOI::outValue_F(int icolumn, double value, bool notdef) {
  if (notdef && undef != "#") {
    notdef = false;
    value = undefV;
  }
  if (notdef) {
    fits_write_col_null(fptr, icolumn+1, fitsLine, 1, 1, &fitsStatus); 
  } else {
    fits_write_col_dbl(fptr, icolumn+1, fitsLine, 1, 1, &value, &fitsStatus);
  }
}

void ArchTOI::endLine_F() {
  fitsLine++;
}

void ArchTOI::closeFile_F() {
  fits_close_file(fptr, &fitsStatus);
  fits_report_error(stderr, fitsStatus);  /* print out any error messages */
}


