#include <iostream.h>
#include <fstream.h>
#include <iomanip.h>

#include "archeopsfile.h"
#include "archtoi.h"
#include "toisvr.h"


#ifdef __MWERKS__
#include <console.h>
#endif

using namespace std;  //introduces namespace std

#ifdef __MWERKS__
#include "Events.h"
#include "LowMem.h"
#include "sioux.h"
static int macSleepTicks = 0;
static int macRunTicks = 10;
static void yield()
{
    EventRecord theEvent;
    static long int macLastTicks;
    long int ticks = LMGetTicks();
    if (ticks - macLastTicks >= macRunTicks) {
      if (WaitNextEvent(everyEvent, &theEvent,macSleepTicks,0))
        SIOUXHandleOneEvent(&theEvent);
      macLastTicks = LMGetTicks();
    }
}
#endif

int main(int argc, char** argv)
{	

  TOISvr svr;
  svr.AddInfo(mjd);
  svr.AddInfo(gyroRaw,0);
  svr.AddInfo(gyroRaw,1);
  svr.AddInfo(gyroRaw,2);
  
  svr.SetDirectory("Sans titre");
  svr.OnBoardRecorderFiles(true);
  svr.SetTimeInterval(1377.88, 1377.95);
  
  // Pour le moment, on sort, en binaire, les points moyennes sur 100
  
  ofstream s("gyro.data",ios::binary);
  ofstream s1("gyro1.data",ios::binary);
  cout << "starting" << endl;
  TOIIter iter = svr.DoQuery();
  const int n=72;
  int i=0;
  int ndata=0;
  double xmjd, gyr0, gyr1, gyr2;
  double gyr00, gyr01, gyr02;
  while (iter.Next()) {
    if (i==0) {
      xmjd = iter.getValue(0);
      gyr0=gyr1=gyr2=0;
      gyr00 = iter.getValue(1);
      gyr01 = iter.getValue(2);
      gyr02 = iter.getValue(3);
    }
    gyr0 += iter.getValue(1);
    gyr1 += iter.getValue(2);
    gyr2 += iter.getValue(3);
    i++;
    if (i >= n) {
      gyr0 /= n;
      gyr1 /= n;
      gyr2 /= n;
      s.write((char*) &xmjd, sizeof(xmjd));
      s.write((char*) &gyr0, sizeof(gyr0));
      s.write((char*) &gyr1, sizeof(gyr1));
      s.write((char*) &gyr2, sizeof(gyr2));
      s1.write((char*) &xmjd, sizeof(xmjd));
      s1.write((char*) &gyr00, sizeof(gyr00));
      s1.write((char*) &gyr01, sizeof(gyr01));
      s1.write((char*) &gyr02, sizeof(gyr02));
      ndata++;
      yield();
      i=0;
    }
  }
  cout << "Done. " << ndata << " samples written." << endl;

}
