// sststarfinder.h
// Eric Aubourg & Dominique Yvon        CEA/DAPNIA/SPP   octobre 1999

#ifndef SSTSTARFINDER_H
#define SSTSTARFINDER_H

#include <math.h>
#include <vector>
#include <map>

#ifndef nb_max_bolo
#define _archeops		//  Acquisition Archeops (avec transputer) 
#define programme
extern "C" {
#include "archeops.h"
}
#endif

#include "sstetoile.h"
#include "pisteetoile.h"
#include "pisteetoile.h"


//#define SST_DEBUG
//#define SSTDUMP
#define SSTChassLog
//#define SSTStatLog

#define NbChanDump (3)
#define	NbPhotDiodBarette (46)
#define NbEtInMapMax 	(100)
#define NbSampleBlock (2*nb_per_block)

#include "toillsstproducer.h"

class SSTStarProcessor {
public:
   virtual void dataFeed(SSTEtoile const&)=0; 
};

class SSTStarFinder : public SSTDataProcessor, public TOIProducer {
public:
  SSTStarFinder();
  ~SSTStarFinder();
  
  virtual void dataFeed(long sampleNum, int* diodeSignal); // signal for 46 diodes...

  static void Has2Bars(bool, int elecOffset=0); // elecOffset : which wired together
  string getName();

  int  getNumbStar(int iSampl);	
  			// return number of star found in sample number iSampl	
  int  getStarZ(int iSampl, int istar); 
  			// return diode number of the star     
  double getStarF(int iSampl, int istar);  
  			// return star flux in Ampre
  double getStarTime(int iSampl, int istar); 
  			// return star time in this sample

  virtual long   firstSampleNum(TOI const&);
  virtual long   lastSampleNum(TOI const&);
  
  virtual bool   canGetValue(long sampleNum, TOI const& toi); // for this samplenum
  virtual bool   canGetPrevValue(long sampleNum, TOI const& toi); 
  virtual bool   canGetNextValue(long sampleNum, TOI const& toi); 
  virtual bool   canGetValueLater(long sampleNum, TOI const& toi);  // Might, later but not now
  
  virtual double getPrevValue(long& sampleNum, TOI const& toi);
  virtual double getNextValue(long& sampleNum, TOI const& toi);
  virtual double getValue(long sampleNum, TOI const& toi);
  virtual long   wontNeedEarlier(TOI const&, TOIAbsorber* client, long);

  void registerProcessor(SSTStarProcessor*);
  void addTOI(TOI& toi, TOIAbsorber* client);

protected:
  vector<SSTStarProcessor*> processors;
  void gotStar(SSTEtoile const& star);

  long lastFedSample; // dernier samplenum vu
  long lastAnaSample; // dernier samplenum utilise par traque
  long lastContSample; // dernier samplenum utilise en mode fill
  
  PisteEtoile** PisteBar; 
  
  	// Are there two photoDiod Arrays and how are they connected?
  static bool  has2bars;
  static int   elecOffset;

  map<double,SSTEtoile> StarHistoryMap;	// On stocke les toiles de manire ordonne en temps
  typedef  map<double,SSTEtoile>::iterator StarHistIter;
  typedef  map<double,SSTEtoile>::const_iterator StarConstHistIter;
  long lastKeptSample;
  
  
  static ofstream sstchass;
  static bool     sstchassinit;
  
  void findStarConstruct();
  void findStarDestruct();
  
  TOILLSSTProducer* sstprod;
};


#endif
