#include "starmatcher.h"
#include "sststarfinder.h"
#include "toimanager.h"
#include "archexc.h"

extern "C" {
#include "aa_hadec.h"
}

#include <stdio.h>

StarMatcher::StarMatcher() {
  possibleTOIs.insert(TOI("dummatcher",      TOI::unspec, "", "blabla"));  
  
  FILE* f;
  
  f = fopen("gsc7.dat","r");
  if (!f) throw ArchExc("Error opening gsc7.dat");
  
  fread(&nstars, sizeof(long), 1 , f);
  stars = new gscStar[nstars];
  fread(stars, sizeof(gscStar), nstars, f);
  fclose(f);

  TOIProducer* prod = TOIManager::findTOIProducer(TOI("sstStarCount"));
  if (!prod) {
    cerr << "StarMatcher : cannot find producer for sstStarCount" << endl;
    exit(-1);
  }
  
  SSTStarFinder* sprod = dynamic_cast<SSTStarFinder*>(prod);
  if (!sprod) {
    cerr << "StarMatcher : producer for sstStarCount is not a SSTStarFinder" << endl;
    exit(-1);
  }
  
  sprod->registerProcessor(this);

}

string StarMatcher::getName() {
  return("StarMatcher 1.0");
}

static ofstream starstream("stars.dat");

void StarMatcher::dataFeed(SSTEtoile const& x) {
  lastStars[(long)x.TEchan] = x;
}


double StarMatcher::getValue(long sampleNum, TOI const& toi) {
  if (lastStars.find(sampleNum) == lastStars.end()) return 0;
  
  SSTEtoile lastStar = lastStars[sampleNum];


  map<TOI, TOIProducer*> m = neededTOIs[toi];
  double lat, lon, ts, alpha, delta, az;
  
  for (map<TOI, TOIProducer*>::iterator i = m.begin(); i != m.end(); i++) {
    TOI inToi = (*i).first;
    TOIProducer* prod =  (*i).second;
    if (inToi.name == "latitude")  lat = prod->getValue(sampleNum, inToi);
    if (inToi.name == "longitude") lon = prod->getValue(sampleNum, inToi);
    if (inToi.name == "tsid")       ts = prod->getValue(sampleNum, inToi);
    if (inToi.name == "alphaFPC")  alpha = prod->getValue(sampleNum, inToi);
    if (inToi.name == "deltaFPC")  delta = prod->getValue(sampleNum, inToi);
    if (inToi.name == "azimuthFPC")   az = prod->getValue(sampleNum, inToi);
  }
    
  // find all stars +- 2 deg boresight
  double dist = 2;
  double dmin = delta - dist; if (dmin<-90) dmin=-90;
  double dmax = delta + dist; if (dmax> 90) dmax= 90;
  double amin = alpha - dist / cos(delta * 3.1415926/180) / 15.;
  if (amin<0) amin += 24;
  double amax = alpha + dist / cos(delta * 3.1415926/180) / 15.;
  if (amax>24) amax -= 24;
  
  int a,b,c;
  a=0; c=nstars-1;
  while (a+1<c) {
    b = (a+c)/2;
    if (stars[b].dec < dmin) a=b; else c=b;
  }
  int imin = a;
  a=0; c=nstars;
  while (a+1<c) {
    b = (a+c)/2;
    if (stars[b].dec < dmax) a=b; else c=b;
  }
  int imax = c;

  for (int i=imin; i<=imax; i++) {
    if (stars[i].ra >= amin && stars[i].ra <= amax) {
      double ha = (ts/3600. - stars[i].ra) * 15. * 3.1415926/180.;
      double elv, azim;
      hadec_aa(lat * 3.1415926/180., ha, stars[i].dec * 3.1415926/180.,
               &elv, &azim);
      elv  *= 180/3.1415926;
      azim *= 180/3.1415926;
      if (azim<0) azim += 360;
     
      starstream << sampleNum << " " << 
        /*lastStar.TEchan << " " <<*/ lastStar.NoDiode << " " <<
        alpha << " " << delta << " " <<
        az << " " << 
        stars[i].ra << " " << stars[i].dec << " " <<
        elv << " " << azim << "\n";
    }
  }
  
  return 1;
}


set<TOI> StarMatcher::reqTOIFor(TOI const&) {
  set<TOI> t; 
  t.insert(TOI("latitude",  TOI::unspec, "interp"));
  t.insert(TOI("longitude", TOI::unspec, "interp"));
  t.insert(TOI("tsid",      TOI::unspec));
  t.insert(TOI("alphaFPC",  TOI::unspec, "galcross0"));
  t.insert(TOI("deltaFPC",  TOI::unspec, "galcross0"));
  t.insert(TOI("azimuthFPC",  TOI::unspec, "galcross0"));
  return t;
}

void StarMatcher::propagateLowBound(TOI const& toi, long sampleNum) {
  for (map<long,SSTEtoile>::iterator i = lastStars.begin(); i != lastStars.end(); i++)
    if ((*i).first < sampleNum) lastStars.erase(i);
}





