// toimanager.h
// Eric Aubourg         CEA/DAPNIA/SPP   septembre 1999

#ifndef TOIMANAGER_H
#define TOIMANAGER_H

#include <set>
#include <map>
#include <iostream.h>
using namespace std;

#include "toi.h"

class TOIProducer;
class TOILowLevProducer;
class TOIAbsorber;

class TOIManager {
public:
  static void registerDefaultProducers();
  static void registerProducer(TOIProducer* p);
  static TOIProducer* findTOIProducer(TOI const& toi); // NULL if cannot build
  
  static set<TOIProducer*> producers;
  
  static void registerLLProducer(TOILowLevProducer* p, int blk_kind);
  static void activateLLProducer(TOILowLevProducer* p);
  static map<TOILowLevProducer*, long> llProducers; // long : masque de bloc
  static map<TOILowLevProducer*, long> activeLLProducers; // long : masque de bloc
  static int trigMask;
  
  static void dumpAvailTOIs(ostream& s);
};

#define REGPROD(_x_) TOIManager::registerProducer(new _x_);
#define REGLLPROD(_x_,_blk_)  TOIManager::registerLLProducer(new _x_, _blk_);


#endif
