// toiproducer.h
// Eric Aubourg         CEA/DAPNIA/SPP   septembre 1999

#ifndef TOIPRODUCER_H
#define TOIPRODUCER_H

#include <set>
#include <map>
#include <deque>

using namespace std;

#include "toi.h"
#include "ark.h"

class TOIAbsorber;
class RequestHandler;

class TOIProducer {
public:
  TOIProducer() {}
  virtual ~TOIProducer() {}
  
  virtual bool   canProduce(TOI const&);
  virtual bool   isProducing(TOI const&);
  virtual void   addTOI(TOI &, TOIAbsorber* client);     // exception si pas productible
  virtual bool   canGetValue(long sampleNum, TOI const& toi); // for this samplenum
  virtual bool   canGetPrevValue(long sampleNum, TOI const& toi); 
  virtual bool   canGetNextValue(long sampleNum, TOI const& toi); 
  virtual bool   canGetValueLater(long sampleNum, TOI const& toi);  // Might, later but not now
  
  virtual double getPrevValue(long& sampleNum, TOI const& toi);
  virtual double getNextValue(long& sampleNum, TOI const& toi);
  virtual double getValue(long sampleNum, TOI const& toi);
  
  virtual long   firstSampleNum(TOI const&);
  virtual long   lastSampleNum(TOI const&);
  
  virtual long   wontNeedEarlier(TOI const&, TOIAbsorber* client, long);
  
  virtual set<string> getAvailOptions(TOI const&);
  virtual set<string> getProperAvailOptions(TOI const&);
  
  virtual void outManifest(RequestHandler*);
  virtual void outVersion(RequestHandler*);
  virtual string getName();
  
  set<TOI> getPossibleTOIs() {return possibleTOIs;}
  
  
protected:
  virtual void   computedValue(TOI const& toi, long sampleNum, double value);

  set<TOI>                               possibleTOIs;
  set<TOI>                               producedTOIs;
  map<TOIAbsorber*, set<TOI> >           clients;
  //map<TOI, map<TOIAbsorber*, long> >     lastNeededSample; 
  //map<TOI, deque<pair<long, double> > >  history;
  map<int, map<TOIAbsorber*, long> >     lastNeededSample; 
  map<int, deque<pair<long, double> > >  history;
  
  deque<pair<long, double> >::const_iterator findHist(TOI const& toi, long sampleNum);
  deque<pair<long, double> >::const_iterator findHist(deque<pair<long, double> >& h, long sampleNum);
};

class ArchFileSet;
class TOILowLevProducer : public TOIProducer {
public:
  virtual void handleBlock(ArchFileSet*)=0; // push !
  virtual void   addTOI(TOI &, TOIAbsorber* client);     // exception si pas productible
};

//#define CHKPROD if (!isProducing(toi)) throw ArchExc("Not producing " + toi.name);
#define CHKPROD toi;


#endif
