// toipullproducer.h
// Eric Aubourg         CEA/DAPNIA/SPP   octobre 1999

#ifndef TOIPULLPRODUCER_H
#define TOIPULLPRODUCER_H

#include "toiderivproducer.h"

class TOIPullProducer : public TOIDerivProducer {
public:
  TOIPullProducer();
  virtual bool   canGetValue(long sampleNum, TOI const& toi); // for this samplenum
  virtual bool   canGetPrevValue(long sampleNum, TOI const& toi); 
  virtual bool   canGetNextValue(long sampleNum, TOI const& toi); 
  virtual bool   canGetValueLater(long sampleNum, TOI const& toi);  // Might, later but not now

  virtual double getPrevValue(long& sampleNum, TOI const& toi);
  virtual double getNextValue(long& sampleNum, TOI const& toi);
  virtual double getValue(long sampleNum, TOI const& toi) = 0;

  virtual long   firstSampleNum(TOI const&);
  virtual long   lastSampleNum(TOI const&);

protected:
  long needBefore;
  long needAfter;

  virtual void         propagateLowBound(TOI const&, long sampleNum);
};



#endif
