// archparam.cc    parametres generaux...
// Eric Aubourg         CEA/DAPNIA/SPP   septembre 1999

#include "archparam.h"
#include <iostream.h>

ArchParam archParam;

// constructeurs avec parametres par defaut adaptes au vol
// TRAPANI 99

ArchParam::AcqParam::AcqParam() 
: tBlock0   (1376.8358818),
  perEch    (0.005836818076),
  utcOrigin (1376.5)
{}

ArchParam::GeomParam::GeomParam() 
{}

ArchParam::SSTParam::SSTParam() 
:  soustPente   (true),
   analFine     (false)
{}


void ArchParam::Dump()
{
  cout << "***Archeops parameters\n";
  cout << " **ACQ\n";
  cout << "   tBlock0      " << acq.tBlock0    << "\n";
  cout << "   perEch       " << acq.perEch     << "\n";
  cout << "   utcOrigin    " << acq.utcOrigin  << "\n";
  cout << " **GEOM\n";
  cout << " **SST\n";
  cout << "   soustPente   " << sst.soustPente << "\n";
  cout << "   analFine     " << sst.analFine   << "\n";
  cout << "***END" << endl;
}

double ArchParam::AcqParam::SN2MJD(double sample) {
  return tBlock0 + sample*perEch/86400.;
}


double ArchParam::AcqParam::MJD2UTC(double mjd) {
  return (mjd - utcOrigin)*24. ;
}

double ArchParam::AcqParam::UTC2MJD(double utc) {
  return utc/24 + utcOrigin;
}

double ArchParam::AcqParam::SN2UTC(double sample) {
  return MJD2UTC(SN2MJD(sample));
}


double ArchParam::AcqParam::MJD2SN(double mjd) {
  return (mjd - tBlock0)/perEch*86400.;
}

