// archtoi.h
// Eric Aubourg         CEA/DAPNIA/SPP   juillet 1999

#ifndef ARCHTOI_H
#define ARCHTOI_H

#include <iostream.h>
#include <string>
#include <list>
#include <vector>
#include "toiiter.h"
#include "fitsio.h"

using namespace std; 

class ArchTOI : public RequestHandler {
public:
  ArchTOI(istream& str);
  ArchTOI(string const& filename);

  void run(string const& outfilename);
  
  enum fmt {ascii_fmt, fits_fmt};
  enum flg {hasflag = 1,
            useNA   = 2};
            
  virtual bool processTOIReq(TOI const& toi, string line);
  virtual bool processOption(string keyw, string args);
  
protected:
  void init();
  TOIIter iter;
  list<string> headertoi;
  list<string> headeropt;
  list<TOI> tois;
  fmt format;
  string undef;
  double undefV;
  bool allBolos; // tous les bolos dans le header. Sinon seulement bolos transmis.
  
  void (ArchTOI::*openFile)(string const& filename);
  void (ArchTOI::*outHeader)(TOIIter& iter);
  void (ArchTOI::*outValue)(int icolumn, double value, bool notdef=false);
  void (ArchTOI::*endLine)();
  void (ArchTOI::*closeFile)();
  
  list<string> buildNames();
  
  void openFile_A(string const& filename);
  void outHeader_A(TOIIter& iter);
  void outValue_A(int icolumn, double value, bool notdef=false);
  void endLine_A();
  void closeFile_A();

  void openFile_F(string const& filename);
  void outHeader_F(TOIIter& iter);
  void outValue_F(int icolumn, double value, bool notdef=false);
  void endLine_F();
  void closeFile_F();
  
  fitsfile* fptr;
  int fitsStatus;
  int fitsLine;
  ostream* ostr;
  
  string requestVersion;
  list<string> comments;
};

#endif
