// gyrocalibrator.h
// Eric Aubourg         CEA/DAPNIA/SPP   octobre 1999

#ifndef GYROCALIBRATOR_H
#define GYROCALIBRATOR_H

#include "toiderivproducer.h"

#include <vector>

class GyroCalibrator : public TOIDerivProducer {
public:
  GyroCalibrator();
  virtual void dataFeed(TOIProducer* source, TOI const& toi, long sampleNum, double value);
  virtual string getName();

  virtual bool   canGetValue(long sampleNum, TOI const& toi); // for this samplenum
  virtual double getValue(long sampleNum, TOI const& toi);

protected:
  virtual set<TOI>     reqTOIFor(TOI const&);
  virtual void         propagateLowBound(TOI const&, long sampleNum);
  
private:
  long startSample;
  vector<double> gyro2; 
  long lastFence1, lastFence2;
};



#endif
