// skyposition.h
// Eric Aubourg         CEA/DAPNIA/SPP   septembre 1999

#ifndef SKYPOSITION_H
#define SKYPOSITION_H

class SkyPosition {
public:
  SkyPosition();
  
  void setEarthLocation(double  latitude, double  longitude);
  void getEarthLocation(double& latitude, double& longitude) const;
  
  void setAltAz(double  altitude, double  azimut);
  void getAltAz(double& altitude, double& azimut) const;
  
  void setEquat(double  ra, double  dec);
  void getEquat(double& ra, double& dec);
  
  void setGalac(double  l, double  b);
  void getGalav(double& l, double& b) const;
  
  void setTSid(double  lst);
  void getTSid(double& lst) const;
  
  // void setMJD(double mjd); Pour faire proprement, garder synchro avec tsid...
  
protected:
  // All this is kept in sync. Recompute from AltAz on location/tsid change.
  double lat, long;
  double alt, az;
  double ra, dec;  
  double tsid;
};

#endif
