// ssthandler.h
// Eric Aubourg         CEA/DAPNIA/SPP   juillet 1999

#ifndef SSTHANDLER_H
#define SSTHANDLER_H

#include <math.h>
#include <vector>
#include <map>

#ifndef nb_max_bolo
#define _archeops		//  Acquisition Archeops (avec transputer) 
#define programme
extern "C" {
#include "archeops.h"
}
#endif

class ArcheopsFile;

// Zone findStar
#include "sstetoile.h"
#include "pisteetoile.h"

//#define SST_DEBUG
//#define SSTDUMP
#define SSTChassLog
//#define SSTStatLog

#define NbChanDump (3)
#define	NbPhotDiodBarette (46)
#define NbEtInMapMax 	(100)
#define NbSampleBlock (2*nb_per_block)
// Fin Zone findStar

class SSTHandler {
public:
  SSTHandler();
  SSTHandler(SSTHandler const&);
  SSTHandler& operator = (SSTHandler const&);
  virtual ~SSTHandler();
  
  enum process { permDiode = 1, 
         findStars  = 2,
         findPeriod = 4,
         findAxis   = 8 };
         
  void NeedProcess(int prcMask);
  void ProcessBlock(block_type_sst*);

  static void Has2Bars(bool, int elecOffset=0); // elecOffset : which wired together
  
  long getLastBlkNum() {return lastBlkNum;}
  int  getRawSignal(int imesure, int idiode); // for last block
  int  getSignal(int imesure, int idiode);    // for last block, imesure<0 -> history
  	
  	//	Zone findStar 
  int  getNumbStar(int iSampl);	
  			// return number of star found in sample number iSampl	
  int  getStarZ(int iSampl, int istar); 
  			// return diode number of the star     
  double getStarF(int iSampl, int istar);  
  			// return star flux in Ampre
  double getStarTime(int iSampl, int istar); 
  			// return star time in this sample

protected:
  int   diodeRaw[nb_per_block*2][48];
  int   diodeHistLength;
  int*  diodeT;       //[>nb_per_block*2]*[nb_photo_diodes];
  int   prcTodo;
  int   starHistLength;
  long  lastBlkNum;
  
  	// Is there two photoDiod Arrays and how are they connected?
  static bool  has2bars;
  static int   elecOffset;
  
  inline int& diode(int iSamp, int iDiod) {return diodeT[iSamp*nb_photo_diodes+iDiod];}
  
  static int  diodpermut[46]; // diodpermut[i] = channel de la diode i
  
  void DecodeTMBlock(block_type_sst*, int i, int* diodes); // mesure i -> diodes
  void PermutDiode(); // diodeRaw -> diode, avec decalage, 1 echantillon.
  int FindStars(block_type_sst* blk); 		// sur les 72 derniers echantillons dans diode.
  						// return nmber of star found in last block
  
  	// 	Zone findStar
  int NbStarInBlock;

  PisteEtoile** PisteBar; 
  	
#ifdef SSTDUMP
  	ofstream** pPisteDump;
#endif

  map<double,SSTEtoile> StarHistoryMap;	
  		// On stocke les etoiles de manire ordonne en temps
  typedef  map<double,SSTEtoile>::iterator StarHistIter;
  typedef  map<double,SSTEtoile>::const_iterator StarConstHistIter;
  
  vector<SSTEtoile> LastBlockStarVec;	
  		// Vecteur des SSTEtoile du block classees en ordre de temps decroissant.
  //vector<SSTEtoile> reverse_iterator StarVecRevIter LastBlockStarVec.rbegin();
  SSTEtoile LastStar;
  PisteEtoile* pPiste;		// Piste courante d'analyse
  int Diodedata[NbSampleBlock];
  int offseDataDiod;
  int LastBlockSSTNb; // Gre la disparition des blocs dfectueux
  int noStarDet;
  int FirstSplNb(block_type_sst* blk); // Calcule l'index du premier echantillon du block analys
  
  static ofstream sstchass;
  static bool     sstchassinit;
  
  void findStarConstruct();
  void findStarDestruct();
};

#endif
