// timetoiproducer.h
// Eric Aubourg         CEA/DAPNIA/SPP   septembre 1999

#ifndef TIMETOIPRODUCER_H
#define TIMETOIPRODUCER_H

#include "toiproducer.h"
#include "ark.h"


class TimeTOIProducer : public TOIProducer {
public:
  TimeTOIProducer();

  virtual bool   canGetValue(long sampleNum, TOI const& toi); // for this samplenum
  virtual bool   canGetPrevValue(long sampleNum, TOI const& toi); 
  virtual bool   canGetNextValue(long sampleNum, TOI const& toi); 
  virtual bool   canGetValueLater(long sampleNum, TOI const& toi);  // Might, later but not now
  
  virtual double getPrevValue(long& sampleNum, TOI const& toi);
  virtual double getNextValue(long& sampleNum, TOI const& toi);
  virtual double getValue(long sampleNum, TOI const& toi);
  
  virtual long   firstSampleNum(TOI const&);
  virtual long   lastSampleNum(TOI const&);
  virtual string getName();
};





#endif
