// toiauxgpsproducer.cc
// Eric Aubourg         CEA/DAPNIA/SPP   octobre 1999

#include "toiauxgpsproducer.h"
#include "archparam.h"
#include "archexc.h"
#include "requesthandler.h"

#define latitude  "latitude"
#define longitude "longitude"
#define altitude  "altitude"


TOIAuxGPSProducer::TOIAuxGPSProducer(AuxGPS* aux)
: auxGPS(aux)
{
  possibleTOIs.insert(TOI(latitude,     TOI::unspec,   "auxGPS interp", "degrees"));  // + = NORTH
  possibleTOIs.insert(TOI(longitude,    TOI::unspec,   "auxGPS interp", "degrees"));  // + = EAST
  possibleTOIs.insert(TOI(altitude,     TOI::unspec,   "auxGPS interp", "meters"));  
}

string TOIAuxGPSProducer::getName() {
  return("TOIAuxGPSProducer 1.0");
}



long TOIAuxGPSProducer::firstSampleNum(TOI const& toi) {
  CHKPROD
  return -99999999;
}

long TOIAuxGPSProducer::lastSampleNum(TOI const& toi) {
  CHKPROD
  return  99999999;
}

bool TOIAuxGPSProducer::canGetValue(long sampleNum, TOI const& toi) {
  CHKPROD
  return auxGPS->canGetLocation(archParam.acq.SN2MJD(sampleNum));
}

bool TOIAuxGPSProducer::canGetValueLater(long /*sampleNum*/, TOI const& toi) {
  CHKPROD
  return false; // we can always get value NOW
}

bool TOIAuxGPSProducer::canGetPrevValue(long sampleNum, TOI const& toi) {
  CHKPROD
  return canGetValue(sampleNum-1,  toi);
}
 
bool TOIAuxGPSProducer::canGetNextValue(long sampleNum, TOI const& toi) {
  CHKPROD
  return canGetValue(sampleNum+1,  toi);
}

double TOIAuxGPSProducer::getValue(long sampleNum, TOI const& toi) {
  CHKPROD
  double lat, lon, alt;
  auxGPS->getLocation(archParam.acq.SN2MJD(sampleNum), lat, lon, alt);
  if (toi.name == latitude)  return lat;
  if (toi.name == longitude) return lon;
  if (toi.name == altitude)  return alt;
  throw ArchExc("TOIAuxGPSProducer inconsistence " + toi.name);
}

double TOIAuxGPSProducer::getPrevValue(long& sampleNum, TOI const& toi) {
  sampleNum--;
  return getValue(sampleNum, toi);
}

double TOIAuxGPSProducer::getNextValue(long& sampleNum, TOI const& toi) {
  sampleNum++;
  return getValue(sampleNum, toi);
}

