// toiderivproducer.cc
// Eric Aubourg         CEA/DAPNIA/SPP   septembre 1999

#include "toiderivproducer.h"
#include "toimanager.h"
#include "archexc.h"
#include "requesthandler.h"

set<TOI> TOIDerivProducer::reqTOIFor(TOI const&) { 
  set<TOI> empty;
  return empty;
}

void TOIDerivProducer::outManifest(RequestHandler* h) {
  outVersion(h);
  h->processOption("#COMMENT", " Producing:");
  for (set<TOI>::iterator i = producedTOIs.begin(); i != producedTOIs.end(); i++) {
    h->processOption("#COMMENT", "  " + (*i).fullName());
    set<TOI> x = reqTOIFor(*i);
    if (!x.empty()) {
      h->processOption("#COMMENT", "  from:");
      for (set<TOI>::iterator j=x.begin(); j!=x.end(); j++) {
        h->processOption("#COMMENT", "   " + (*j).fullName());
      }
    }
  }
}


bool TOIDerivProducer::canProduce(TOI const& toi) {
  // 1. Already in cache ?
  map<TOI, map<TOI, TOIProducer*> >::const_iterator j = neededTOIs.find(toi);
  if (j != neededTOIs.end()) return true;

  // 2. It should be in our list of possibleTOI's
  TOI myTOI;
  for (set<TOI>::const_iterator i = possibleTOIs.begin(); i != possibleTOIs.end(); i++) {
    if ((toi.name == (*i).name) &&
        (toi.index == (*i).index || (*i).index == TOI::all)) {
      myTOI = (*i); 
      break;
    }
  }
  if (myTOI.name == "") return false; // not in list
  
  // 3. Handle options
  
  set<string> extraopts = toi.options;
  
  // 3a should contain mandatory options
  for (set<string>::iterator i = myTOI.reqOptions.begin(); 
       i != myTOI.reqOptions.end(); i++) {
    if (extraopts.find(*i) == extraopts.end()) return false;
  }
  
  // 3b remove local options
  
  for (set<string>::iterator i = myTOI.options.begin();
       i != myTOI.options.end(); i++) {
    extraopts.erase(*i);   
  }
  
  // 4. Find producers, distribute remaining options
  map<TOI, TOIProducer*> fullInputTOI;
  set<TOI> inputTOIs = reqTOIFor(toi);
  for (set<TOI>::iterator i = inputTOIs.begin(); i != inputTOIs.end(); i++) {
    TOI inTOI = *i;
    TOIProducer* prod = TOIManager::findTOIProducer(inTOI);
    if (!prod) return false;
    if (!extraopts.empty()) {
      set<string> xopts = prod->getAvailOptions(inTOI);
      for (set<string>::iterator j = xopts.begin(); j != xopts.end(); j++) {
        if (extraopts.find(*j) != extraopts.end()) {
          inTOI.options.insert(*j);
          extraopts.erase(*j);
        }
      }
    }
    fullInputTOI[inTOI] = prod;
  }
  
  if (!extraopts.empty()) return false;
  
  neededTOIs[toi] = fullInputTOI;
  return true;
}

set<string> TOIDerivProducer::getAvailOptions(TOI const& toi) {
 // toi.options.clear();
 // toi.index = -2;
 // if (!canProduce(toi)) throw ArchExc("cannot produce " + toi.name);
  set<string> s = getProperAvailOptions(toi);
  map<TOI, TOIProducer*> need = neededTOIs[toi];
  for (map<TOI, TOIProducer*>::iterator i = need.begin(); i != need.end(); i++) {
    set<string> s1 = (*i).second->getAvailOptions((*i).first);
    s.insert(s1.begin(), s1.end());
  }
  return s;
}

void TOIDerivProducer::addTOI(TOI& toi, TOIAbsorber* client) {
  TOIProducer::addTOI(toi, client);
  map<TOI, TOIProducer*> m = neededTOIs[toi];
  for (map<TOI, TOIProducer*>::iterator i = m.begin(); i != m.end(); i++) {
    TOI toi2 = (*i).first;
    (*i).second->addTOI(toi2,this);
  }
}

long TOIDerivProducer::wontNeedEarlier(TOI const& toi, TOIAbsorber* client, long t) {
  long xt = TOIProducer::wontNeedEarlier(toi, client, t);
  if (xt>0) propagateLowBound(toi, xt);
  return xt;
}

// if no need for past values...
void TOIDerivProducer::propagateLowBound(TOI const& toi, long sampleNum) {
  CHKPROD
  map<TOI, TOIProducer*> need = neededTOIs[toi];
  for (map<TOI, TOIProducer*>::iterator i = need.begin(); i != need.end(); i++) {
    (*i).second->wontNeedEarlier((*i).first, this, sampleNum);
  }
}
