// toiiter.h
// Eric Aubourg         CEA/DAPNIA/SPP   septembre 1999

#ifndef TOIITER_H
#define TOIITER_H

#include <vector>
#include <list>
#include <set>
#include <map>
#include <string>

#include "toiabsorber.h"
#include "requesthandler.h"
#include "archfileset.h"

class AuxGPS;

template <class T1, class T2, class T3>
struct triple {
    T1 first;
    T2 second;
    T3 third;
	triple() : first(T1()), second(T2()), third(T3()) {}
    triple (const T1& a, const T2& b, const T3& c) :
           first (a), second (b), third (c) {}
};

class TOIIter : public TOIAbsorber /*, public RequestHandler*/ {
public:
  TOIIter();
  // ~TOIIter();
  
  void readReq(istream& s);
  void defaultInclude();

  bool processRequest(string line);
  void registerReqHandler(RequestHandler*);

  virtual bool processTOIReq(TOI& toi, string);
  virtual bool processOption(string keyw, string args);

  void addDirectory(string);
  void addFile(string);
  //void useAuxGPS(AuxGPS* gps);
   
  void setMJDInterval(double tStart, double tEnd);
  void setUTCInterval(double tStart, double tEnd);
  void setSNInterval(long sStart, long sEnd);
  void setUnderSample(int n);
  int  getUnderSample();

  void addTOI(TOI& toi, bool triggering=true);

  void init();
  
  bool next();
   
  long    getSampleNum();
  bool    canGetValue(int column);  // data is available for that...
  double  getValue(int column);
  bool    canGetValue(TOI const& toi);  // data is available for that...
  double  getValue(TOI const& toi);
  bool    newValue(int column);     // a juste change ?
  bool    extendValue(int column);  // une valeur plus ancienne, etendue ?
  bool    interpValue(int column);  // une valeur interpolee avec valeur future ?
  bool    isTrig(int column);  
  TOI     getKind(int column);
  
  ArchFileSet& getFSet() {return fset;}
      
protected:   
  ArchFileSet fset;
  list<RequestHandler*> handlers;
  enum {triggering = 1};
  typedef ::triple<TOI,TOIProducer*,long> TOIInfo;
  vector<TOIInfo> request; 
   
  double mjdStart, mjdEnd;  // MJD
  double utcStart, utcEnd;  // UTC, will be converted towards tStart tEnd at init
  long   sStart, sEnd;      // samplenum
        
  int underSample;
  long curSample;
   
  int getColTOI(TOI const& toi);
  bool next1();

private:
  bool initDone;
  bool incDone;
};

#endif
