// toillboloproducer.cc
// Eric Aubourg         CEA/DAPNIA/SPP   septembre 1999

#include "toillboloproducer.h"
#include "archfileset.h"
#include "toimanager.h"
#include "requesthandler.h"

#define raw "rawBoloData"
#define muv "boloRawMuV"
#define muvCN "boloRawMuVCN"

#define  val_DS(j,i)  (blk->data_bolo[j][i]&0x1fffff)

TOILLBoloProducer::TOILLBoloProducer()
{
  possibleTOIs.insert(TOI(raw, TOI::all, "", "ADU"));  
  possibleTOIs.insert(TOI(muv, TOI::all, "", "microVolts"));
  possibleTOIs.insert(TOI(muvCN, TOI::all, "", "microVolts"));
}

string TOILLBoloProducer::getName() {
  return("TOILLBoloProducer 1.0");
}


void TOILLBoloProducer::handleBlock(ArchFileSet* fs)
{
  block_type_bolo* blk = fs->lastBolo();
  long sample0 = numero_block(blk)*72;
  for (set<TOI>::iterator i = producedTOIs.begin(); i != producedTOIs.end(); i++) {
    int ibolo = (*i).index;
    if ((*i).name == raw) {
      for (int j=0; j<nb_per_block*2; j++) {
        computedValue((*i),sample0+j, val_DS(ibolo,j));
      }
    } else if ((*i).name == muv) {
      block_type_reglage* reglage = fs->lastReglage();
      block_type_param*   param   = fs->lastParam();
      for (int j=0; j<nb_per_block*2; j++) {
        int s = j % 2 ? 1 : -1;
        computedValue((*i),sample0+j, 
          s*bolo_muV(&param->param, &reglage->reglage, val_DS(ibolo,j), ibolo));
      }
    } else if ((*i).name == muvCN) {
	  // Si pas bloc comprime -> 1 bit
	  int lastbit = 1;
	  block_type_reglage* reglage = fs->lastReglage();
	  block_type_param*   param = fs->lastParam();
	  bool isComp = (!(fs->lastBoloComp() == NULL) &&
	      (numero_block(fs->lastBoloComp()) != numero_block(fs->lastBolo())));
	  unsigned int4* data = isComp ? fs->lastBoloComp()->data_bolo[ibolo] : NULL;
      for (int imesure=0; imesure<nb_per_block*2; imesure++) {
	    // Les deux premieres valeurs sont codees directement...
	    if (isComp && (imesure>=2)) {
	      int iExp = (imesure-2)/4 + 1;
	      int expo = data[iExp] & 0xf;
	      lastbit = 1 << expo;
	    } else {
	      lastbit = 1;
	    }
	    double noise = (
	      bolo_muV(&param->param, &reglage->reglage, lastbit, ibolo) -
	      bolo_muV(&param->param, &reglage->reglage, 0, ibolo)) /2.;
        computedValue((*i),sample0+imesure,noise);
	  }
    }
  }
}

