// toillgyroproducer.cc
// Eric Aubourg         CEA/DAPNIA/SPP   octobre 1999

#include "toillgyroproducer.h"
#include "archfileset.h"
#include "toimanager.h"
#include "requesthandler.h"

#define gyroRaw    "gyroRaw"
#define gyroV      "gyroV"
#define gyroCal    "gyroCal"
#define gyroSpeed  "gyroSpeed"

TOILLGyroProducer::TOILLGyroProducer()
{
  possibleTOIs.insert(TOI(gyroRaw,   TOI::all, "", "ADU"));  
  possibleTOIs.insert(TOI(gyroV,     TOI::all, "", "Volts"));
  possibleTOIs.insert(TOI(gyroCal,   TOI::unspec, "", "deg/s/V", "theoric"));
  possibleTOIs.insert(TOI(gyroSpeed, TOI::all, "", "deg/s", "theoric"));
}

string TOILLGyroProducer::getName() {
  return("TOILLGyroProducer 1.0");
}


static inline long gyrRaw(block_type_gyro* blk, int igyro, int imesure) {
  return blk->gyro[igyro][imesure]-32768;
}

static inline double gyrV(block_type_gyro* blk, int igyro, int imesure) {
  return gyrRaw(blk, igyro, imesure) * 2. / 32768.; // +- 2V dynamique sur 16 bits;
}

static inline double gyrSpeed(block_type_gyro* blk, int igyro, int imesure) {
  return gyrV(blk, igyro, imesure) * 10;
}

void TOILLGyroProducer::handleBlock(ArchFileSet* fs)
{
  block_type_gyro* blk = fs->lastGyro();
  long sample0 = numero_block(blk)*72;
  for (set<TOI>::iterator i = producedTOIs.begin(); i != producedTOIs.end(); i++) {
    int igyro = (*i).index;
    if ((*i).name == gyroRaw) {
      for (int j=0; j<nb_per_block*2; j++) {
        computedValue((*i),sample0+j, gyrRaw(blk,igyro,j));
      }
    } else if ((*i).name == gyroV) {
      for (int j=0; j<nb_per_block*2; j++) {
        computedValue((*i),sample0+j, gyrV(blk,igyro,j));
      }
    } else if ((*i).name == gyroCal) {
      for (int j=0; j<nb_per_block*2; j++) {
        computedValue((*i),sample0+j, 10);
      }
    } else if ((*i).name == gyroSpeed) {
      for (int j=0; j<nb_per_block*2; j++) {
        computedValue((*i),sample0+j, gyrSpeed(blk,igyro,j));
      }
    }
  }
}

