// toillreglageproducer.cc
// Eric Aubourg         CEA/DAPNIA/SPP   septembre 1999

#include "toillreglageproducer.h"
#include "archfileset.h"
#include "toimanager.h"
#include "requesthandler.h"

// horloge
#define horlPeriode    "horlPeriode"
#define horlNbMesures  "horlNbMesures"
#define horlTempMort   "horlTempMort"
#define horlFlag       "horlFlag"

// regul_bolo
#define regMode        "regMode"         // index regul 
#define regNumBolo     "regNumBolo"
#define regVoieChauf   "regVoieChauf"
#define regProp        "regProp"
#define regInteg       "regInteg"
#define regDeriv       "regDeriv"
#define regChauffage   "regChauffage"

// auto_bolo
#define autoBolMode    "autoBolMode"     // index voie
#define autoBolGain    "autoBolGain"
#define autoBolCourant "autoBolCourant"
#define autoBolDelai   "autoBolDelai"

// auto_dilu
#define autoDilVanne   "autoDilVanne"
#define autoDilHelium  "autoDilHelium"
#define autoDilChauff  "autoDilChauff"
#define autoDilPiles   "autoDilPiles"
#define autoDilTrans   "autoDilTrans"
#define autoDilTMxVan  "autoDilTMxVan"
#define autoDilxx7     "autoDilxx7"
#define autoDilxx8     "autoDilxx8"

// reglage_un_bolo
#define boloDACV       "boloDACV"       // index bolo
#define boloDACI       "boloDACI"


TOILLReglageProducer::TOILLReglageProducer()
{
  possibleTOIs.insert(TOI(horlPeriode,   TOI::unspec, "", "CHAR-CODED"));  
  possibleTOIs.insert(TOI(horlNbMesures, TOI::unspec, "", "CHAR-CODED"));  
  possibleTOIs.insert(TOI(horlTempMort,  TOI::unspec, "", "CHAR-CODED"));  
  possibleTOIs.insert(TOI(horlFlag,      TOI::unspec, "", "CHAR-CODED"));  
  
  possibleTOIs.insert(TOI(regMode,       TOI::all,    "", "CHAR-CODED"));  
  possibleTOIs.insert(TOI(regNumBolo,    TOI::all,    "", "CHAR-CODED"));  
  possibleTOIs.insert(TOI(regVoieChauf,  TOI::all,    "", "CHAR-CODED"));  
  possibleTOIs.insert(TOI(regProp,       TOI::all,    "", "CHAR-CODED"));  
  possibleTOIs.insert(TOI(regInteg,      TOI::all,    "", "CHAR-CODED"));  
  possibleTOIs.insert(TOI(regDeriv,      TOI::all,    "", "CHAR-CODED"));  
  possibleTOIs.insert(TOI(regChauffage,  TOI::all,    "", "CHAR-CODED"));  

  possibleTOIs.insert(TOI(autoBolMode,   TOI::all,    "", "CHAR-CODED"));  
  possibleTOIs.insert(TOI(autoBolGain,   TOI::all,    "", "CHAR-CODED"));  
  possibleTOIs.insert(TOI(autoBolCourant,TOI::all,    "", "CHAR-CODED"));  
  possibleTOIs.insert(TOI(autoBolDelai,  TOI::all,    "", "CHAR-CODED"));  

  possibleTOIs.insert(TOI(autoDilVanne,  TOI::unspec, "", "CHAR-CODED"));  
  possibleTOIs.insert(TOI(autoDilHelium, TOI::unspec, "", "CHAR-CODED"));  
  possibleTOIs.insert(TOI(autoDilChauff, TOI::unspec, "", "CHAR-CODED"));  
  possibleTOIs.insert(TOI(autoDilPiles,  TOI::unspec, "", "CHAR-CODED"));  
  possibleTOIs.insert(TOI(autoDilTrans,  TOI::unspec, "", "CHAR-CODED"));  
  possibleTOIs.insert(TOI(autoDilTMxVan, TOI::unspec, "", "CHAR-CODED"));  
  possibleTOIs.insert(TOI(autoDilxx7,    TOI::unspec, "", "CHAR-CODED"));  
  possibleTOIs.insert(TOI(autoDilxx8,    TOI::unspec, "", "CHAR-CODED"));  
  
  possibleTOIs.insert(TOI(boloDACV,      TOI::all,    "", "microVolts"));  
  possibleTOIs.insert(TOI(boloDACI,      TOI::all,    "", "microAmps"));  
}

string TOILLReglageProducer::getName() {
  return("TOILLReglageProducer 1.0");
}



#define COMPTOI(_toi_, _field_)                               \
    if ((*i).name == _toi_) {                                 \
      computedValue((*i),sample0, blk->reglage._field_);      \
    }

void TOILLReglageProducer::handleBlock(ArchFileSet* fs)
{
  block_type_reglage* blk = fs->lastReglage();
  long sample0 = numero_block(blk)*72;
  for (set<TOI>::iterator i = producedTOIs.begin(); i != producedTOIs.end(); i++) {
    int k = (*i).index;
    COMPTOI(horlPeriode,    horloge.periode) else
    COMPTOI(horlNbMesures,  horloge.nb_mesures) else
    COMPTOI(horlTempMort,   horloge.temp_mort) else
    COMPTOI(horlFlag,       horloge.flag) else
    COMPTOI(regMode,        regul[k].mode) else
    COMPTOI(regNumBolo,     regul[k].num_bolo) else
    COMPTOI(regVoieChauf,   regul[k].voie_chauf) else
    COMPTOI(regProp,        regul[k].prop) else
    COMPTOI(regInteg,       regul[k].integ) else
    COMPTOI(regDeriv,       regul[k].deriv) else
    COMPTOI(regChauffage,   regul[k].chauffage) else
    COMPTOI(autoBolMode,    autom[k].mode) else
    COMPTOI(autoBolGain,    autom[k].gain) else
    COMPTOI(autoBolCourant, autom[k].courant) else
    COMPTOI(autoBolDelai,   autom[k].delai) else
    COMPTOI(autoDilVanne,   dilu.vanne) else
    COMPTOI(autoDilHelium,  dilu.helium) else
    COMPTOI(autoDilChauff,  dilu.chauffage) else
    COMPTOI(autoDilPiles,   dilu.piles) else
    COMPTOI(autoDilTrans,   dilu.transmission) else
    COMPTOI(autoDilTMxVan,  dilu.temps_max_vanne) else
    COMPTOI(autoDilxx7,     dilu.xx7) else
    COMPTOI(autoDilxx8,     dilu.xx8) else
    if ((*i).name == boloDACV) {
      computedValue((*i), sample0, DAC_muV(&fs->lastParam()->param, &blk->reglage, k));
    } else
    if ((*i).name == boloDACI) {
      computedValue((*i), sample0, DAC_muA(&fs->lastParam()->param, &blk->reglage, k));
    }
  }
}



