// toillsstproducer.cc
// Eric Aubourg         CEA/DAPNIA/SPP   octobre 1999

#include "toillsstproducer.h"
#include "archfileset.h"
#include "toimanager.h"
#include "requesthandler.h"

#define sstChannel    "sstChannel"
#define sstChannelCN  "sstChannelCN"
#define sstDiode      "sstDiode"
#define sstDiodeCN    "sstDiodeCN"

// diodpermut[i] = channel de la diode i
int TOILLSSTProducer::diodpermut[46]=
 { 8,24,40, 9,25,41,10,26,42,11,
  27,43,16,32, 1,17,33, 2,18,34,
   3,19,35,12,28,44,13,29,45,14,
  30,46,15,31,47,20,36, 5,21,37,
   6,22,38, 7,23,39};
 // voies 0 et 4 non connectees, voie 1 en panne.


TOILLSSTProducer::TOILLSSTProducer()
{
  possibleTOIs.insert(TOI(sstChannel,       TOI::all, "", "ADU"));  
  possibleTOIs.insert(TOI(sstChannelCN,     TOI::all, "", "ADU"));
  possibleTOIs.insert(TOI(sstDiode,         TOI::all, "", "ADU"));  
  possibleTOIs.insert(TOI(sstDiodeCN,       TOI::all, "", "ADU"));
}

string TOILLSSTProducer::getName() {
  return("TOILLSSTProducer 1.0");
}


void TOILLSSTProducer::registerProcessor(SSTDataProcessor* p) {
  processors.push_back(p);
}

void TOILLSSTProducer::DecodeTMBlock(block_type_sst* blk, int i, int* diod)
{
  int j; // 0-5 : numero du bloc de 8 diodes
  int k; // 0-2 : indice du bloc de 4 bits (une diode = 12 bits = 3 blocs de 4 bits)
  int l; // 0-7 : indice de la diode dans son bloc (8 diodes * 4 bits = 1 mot de 32 bits)
  
  // numero de la diode (0-47) = j*8+l;
  // indice dans le bloc sst du mot de 32 bits (0-17) = j*3+k;
  // indice dans mot de 32 bits du premier bit utile = 4*l;
    
  for (j=0; j<48; j++) diod[j] = 0;
  
  for (j=0; j<6; j++)
    for (k=0; k<3; k++)
      for (l=0; l<8; l++) {
        int4 word = blk->sst[i][j*3+k];
        word = (word >> (4*l)) & 0xF;
        diod[j*8+l] = (diod[j*8+l] << 4) + word;
      }

  for (j=0; j<48; j++)  diod[j] -= 2048;
}

double TOILLSSTProducer::getSSTRawSignalCN(ArchFileSet* fs, int ichannel, int imesure) {
  // Si pas bloc comprime -> 0.5
  if (fs->lastSSTComp() == NULL) return .5;
  if (numero_block(fs->lastSSTComp()) != numero_block(fs->lastSST())) return 0.5;
  
  // Attention, on ne transmet pas les canaux 0 et 4....
  if (ichannel == 0 || ichannel == 4) return 0;
  int i = ichannel - 1;
  if (i >= 4) i--;
  unsigned int4* data = fs->lastSSTComp()->sst[i];
  // Les deux premieres valeurs sont codees directement...
  if (imesure<2) return 0.5;
  int iExp = (imesure-2)/7 + 1;
  int expo = data[iExp] & 0xf;
  int noise = 1 << expo;
  return noise/2.;
}

void TOILLSSTProducer::handleBlock(ArchFileSet* fs)
{
  block_type_sst* blk = fs->lastSST();
  long sample0 = numero_block(blk)*72;
  int channels[48];
  int diodes[46];
  for (int j=0; j<nb_per_block*2; j++) {
    DecodeTMBlock(blk, j, channels);
    for (int i=0; i<46; i++)
      diodes[i] = channels[diodpermut[i]];
    for (vector<SSTDataProcessor*>::iterator i = processors.begin(); 
         i != processors.end(); i++) {
      (*i)->dataFeed(sample0 + j, diodes);    
    }
    for (set<TOI>::iterator i = producedTOIs.begin(); i != producedTOIs.end(); i++) {
      int ich = (*i).index;
      if ((*i).name == sstChannel) {
        computedValue((*i), sample0+j, channels[ich]);
      } else if ((*i).name == sstDiode) {
        computedValue((*i), sample0+j, diodes[ich]);
      } else if ((*i).name == sstChannelCN) {
        computedValue((*i), sample0+j, getSSTRawSignalCN(fs, ich, j));
      } else if ((*i).name == sstDiodeCN) {
        computedValue((*i), sample0+j, getSSTRawSignalCN(fs, diodpermut[ich], j));
      }
    }
  }
}

