// toillsstproducer.h
// Eric Aubourg         CEA/DAPNIA/SPP   octobre 1999

#ifndef TOILLSSTPRODUCER_H
#define TOILLSSTPRODUCER_H

#include "toiproducer.h"
#include "ark.h"

class SSTDataProcessor {
public:
   virtual void dataFeed(long sampleNum, int* diodeSignal)=0; // signal for 46 diodes...
};

class TOILLSSTProducer : public TOILowLevProducer {
public:
  TOILLSSTProducer();
  void handleBlock(ArchFileSet*); // push !
  
  void registerProcessor(SSTDataProcessor*);
  virtual string getName();

protected:
  static int  diodpermut[46]; // diodpermut[i] = channel de la diode i
  vector<SSTDataProcessor*> processors;
  
  void DecodeTMBlock(block_type_sst* blk, int i, int* diod);
  double getSSTRawSignalCN(ArchFileSet* fs, int ichannel, int imesure);
};





#endif
