// archfileset.h
// Eric Aubourg         CEA/DAPNIA/SPP   septembre 1999

#ifndef ARCHFILESET_H
#define ARCHFILESET_H

#include "archeopsfile.h"

#include <set>
#include <map>

using namespace std;

class TOILowLevProducer;

class ArchFileSet {
public:
  ArchFileSet();
  ArchFileSet(ArchFileSet const&);
  ~ArchFileSet();
  
  void addFile(string);
  void addDirectory(string);
  void setSNumRange(long start, long end);
  void setMJDRange(double start, double end);
  void init(); // Opens the first file.
  bool next();
  
  block_type_param*         lastParam();  
  block_type_journal*       lastJournal();
  block_type_reglage*       lastReglage();
  block_type_dilution*      lastDilution();
  block_type_gps*           lastGPS();
  block_type_une_periode*   lastUnePeriode();
  block_type_synchro_sol*   lastSynchroSol();
  block_type_pointage_sol*  lastPointageSol();
  block_type_bolo*          lastBolo();   
  block_type_gyro*          lastGyro();
  block_type_sst*           lastSST();
  block_type_bolo_comprime* lastBoloComp();   
  block_type_gyro_comprime* lastGyroComp();
  block_type_sst_comprime*  lastSSTComp();
  
  void   registerProducer(TOILowLevProducer*, int blk_kind);
  long   getSampleIndex();             // numero d''echantillon 
  double getMJD();            

protected:
  set<string> filenames;
  set<string> directories;
  map<string, long> file1stSamp; // premier echantillon de chaque fichier
  set<string>::iterator curFile;
  ArcheopsFile* file;
            
  void scanFiles(); // Parcourt tous les fichiers, cherche le premier echantillon...
  long nextSample(); // no test of trange
  bool nextFile();
  long sStart, sEnd;      // samplenum
  double mjdStart, mjdEnd;    
  long trigMask;
  bool initDone;
  bool endFound;
};

#endif
