// galcrosslocator.cc
// Eric Aubourg         CEA/DAPNIA/SPP   octobre 1999

#include "galcrosslocator.h"
#include "archexc.h"
#include "archparam.h"
#include "templocator.h"

#define alphaZenith     "alphaZenith"
#define deltaZenith     "deltaZenith"
#define rotSpeed        "rotSpeed"
#define rotSpeedSample1 "rotSpeedSample1"
#define rotSpeedSample2 "rotSpeedSample2"
#define lastCrossSample "lastCrossSample"
#define nextCrossSample "nextCrossSample"
#define azimuthFPC      "azimuthFPC"
#define elvFPC          "elvFPC"
#define alphaFPC        "alphaFPC"
#define deltaFPC        "deltaFPC"
#define azimuthBolo     "azimuthBolo"
#define elvBolo         "elvBolo"
#define alphaBolo       "alphaBolo"
#define deltaBolo       "deltaBolo"


GalCrossLocator::GalCrossLocator() {
  possibleTOIs.insert(TOI(alphaZenith,      TOI::unspec, "", "hours",   "galcross0"));  
  possibleTOIs.insert(TOI(deltaZenith,      TOI::unspec, "", "degrees", "galcross0"));  
  possibleTOIs.insert(TOI(rotSpeed,         TOI::unspec, "", "deg/s",   "galcross0"));  
  possibleTOIs.insert(TOI(rotSpeedSample1,  TOI::unspec, "", "integer", "galcross0"));  
  possibleTOIs.insert(TOI(rotSpeedSample2,  TOI::unspec, "", "integer", "galcross0"));  
  possibleTOIs.insert(TOI(lastCrossSample,  TOI::unspec, "", "integer", "galcross0"));  
  possibleTOIs.insert(TOI(lastCrossSample,  TOI::unspec, "", "integer", "galcross0"));  
  possibleTOIs.insert(TOI(nextCrossSample,  TOI::unspec, "", "integer", "galcross0"));  
  possibleTOIs.insert(TOI(azimuthFPC,       TOI::unspec, "", "degrees", "galcross0"));  
  possibleTOIs.insert(TOI(elvFPC,           TOI::unspec, "", "degrees", "galcross0"));  
  possibleTOIs.insert(TOI(alphaFPC,         TOI::unspec, "", "hours",   "galcross0"));  
  possibleTOIs.insert(TOI(deltaFPC,         TOI::unspec, "", "degrees", "galcross0"));  
  possibleTOIs.insert(TOI(azimuthBolo,      TOI::all,    "", "degrees", "galcross0"));  
  possibleTOIs.insert(TOI(elvBolo,          TOI::all,    "", "degrees", "galcross0"));  
  possibleTOIs.insert(TOI(alphaBolo,        TOI::all,    "", "hours",   "galcross0"));  
  possibleTOIs.insert(TOI(deltaBolo,        TOI::all,    "", "degrees", "galcross0"));  
}

string GalCrossLocator::getName() {
  return("GalCrossLocator 1.0");
}

bool GalCrossLocator::canGetValue(long sampleNum, TOI const&) {
  int dum;
  return (tempLocator.getCrossSamples(sampleNum, dum, dum) == 0);
}


double GalCrossLocator::getValue(long sampleNum, TOI const& toi) {
  if (!canGetValue(sampleNum, toi)) return -1;

  map<TOI, TOIProducer*> m = neededTOIs[toi];
  double lat, lon, ts;
  
  for (map<TOI, TOIProducer*>::iterator i = m.begin(); i != m.end(); i++) {
    TOI inToi = (*i).first;
    TOIProducer* prod =  (*i).second;
    if (inToi.name == "latitude")  lat = prod->getValue(sampleNum, inToi);
    if (inToi.name == "longitude") lon = prod->getValue(sampleNum, inToi);
    if (inToi.name == "tsid")       ts = prod->getValue(sampleNum, inToi);
  }
    
  tempLocator.setEarthPos(lon,lat);
  tempLocator.setTSid(ts);

  if (toi.name == alphaZenith)     return tempLocator.getAlphaZenith();
  if (toi.name == deltaZenith)     return tempLocator.getDeltaZenith();
  if (toi.name == rotSpeed)        return tempLocator.getRotSpeed(sampleNum);

  if (toi.name == azimuthFPC)      return tempLocator.getAzimutCenter(sampleNum);
  if (toi.name == elvFPC)          return tempLocator.getElvCenter(sampleNum);
  if (toi.name == alphaFPC)        return tempLocator.getAlphaCenter(sampleNum);
  if (toi.name == deltaFPC)        return tempLocator.getDeltaCenter(sampleNum);
  
  if (toi.name == azimuthBolo)     return tempLocator.getAzimutBolo(sampleNum, toi.index);
  if (toi.name == elvBolo)         return tempLocator.getElvBolo(sampleNum, toi.index);
  if (toi.name == alphaBolo)       return tempLocator.getAlphaBolo(sampleNum, toi.index);
  if (toi.name == deltaBolo)       return tempLocator.getDeltaBolo(sampleNum, toi.index);

  if (toi.name == lastCrossSample || toi.name == rotSpeedSample1) {
     int SN1, SN2;
     tempLocator.getCrossSamples(sampleNum, SN1, SN2);
     return SN1;
  } 
  if (toi.name == nextCrossSample || toi.name == rotSpeedSample2) {
     int SN1, SN2;
     tempLocator.getCrossSamples(sampleNum, SN1, SN2);
     return SN2;
  } 
  
  return -1;
}


set<TOI> GalCrossLocator::reqTOIFor(TOI const&) {
  set<TOI> t; 
  t.insert(TOI("latitude",  TOI::unspec, "interp"));
  t.insert(TOI("longitude", TOI::unspec, "interp"));
  t.insert(TOI("tsid",      TOI::unspec));
  return t;
}







