#ifndef STARMATCHER_H
#define STARMATCHER_H


#include "sststarfinder.h"
#include "toipullproducer.h"

class StarMatcher: public SSTStarProcessor, public TOIPullProducer {
public:
  StarMatcher();
  
  virtual void dataFeed(SSTEtoile const&); 

  virtual string getName();
  virtual double getValue(long sampleNum, TOI const& toi);

protected:
  virtual set<TOI>     reqTOIFor(TOI const&);
  void  propagateLowBound(TOI const& toi, long sampleNum);
#pragma options align=mac68k
  struct gscStar {
    float ra;
    float dec;
    short mag; // mag * 100
  };
#pragma options align=reset
  
  gscStar* stars;
  long nstars;
  
  map<long,SSTEtoile> lastStars;
};


#endif
