// timetoiproducer.cc
// Eric Aubourg         CEA/DAPNIA/SPP   septembre 1999

#include "timetoiproducer.h"
#include "archparam.h"
#include "archexc.h"
#include "requesthandler.h"

#define sn "sampleNum"
#define mjd "MJD"
#define utc "UTC"


TimeTOIProducer::TimeTOIProducer()
{
  possibleTOIs.insert(TOI(sn,  TOI::unspec, "", "integer"));  
  possibleTOIs.insert(TOI(mjd, TOI::unspec, "", "days"));
  possibleTOIs.insert(TOI(utc, TOI::unspec, "", "hours"));
}

string TimeTOIProducer::getName() {
  return("TimeTOIProducer 1.0");
}



long TimeTOIProducer::firstSampleNum(TOI const& toi) {
  CHKPROD
  return -99999999;
}

long TimeTOIProducer::lastSampleNum(TOI const& toi) {
  CHKPROD
  return  99999999;
}

bool TimeTOIProducer::canGetValue(long /*sampleNum*/, TOI const& toi) {
  CHKPROD
  return true;
}

bool TimeTOIProducer::canGetValueLater(long /*sampleNum*/, TOI const& toi) {
  CHKPROD
  return false; // we can always get value NOW
}

bool TimeTOIProducer::canGetPrevValue(long /*sampleNum*/, TOI const& toi) {
  CHKPROD
  return true;
}
 
bool TimeTOIProducer::canGetNextValue(long /*sampleNum*/, TOI const& toi) {
  CHKPROD
  return true;
}

double TimeTOIProducer::getValue(long sampleNum, TOI const& toi) {
  CHKPROD
  if (toi.name == sn) return sampleNum;
  if (toi.name == mjd) return archParam.acq.SN2MJD(sampleNum);
  if (toi.name == utc) return archParam.acq.SN2UTC(sampleNum);
  throw ArchExc("TimeTOIProducer inconsistence " + toi.name);
}

double TimeTOIProducer::getPrevValue(long& sampleNum, TOI const& toi) {
  sampleNum--;
  return getValue(sampleNum, toi);
}

double TimeTOIProducer::getNextValue(long& sampleNum, TOI const& toi) {
  sampleNum++;
  return getValue(sampleNum, toi);
}
