// toiderivproducer.h
// Eric Aubourg         CEA/DAPNIA/SPP   septembre 1999

#ifndef TOIDERIVPRODUCER_H
#define TOIDERIVPRODUCER_H

#include "toiproducer.h"
#include "toiabsorber.h"

class TOIDerivProducer : public TOIProducer, public TOIAbsorber {
public:

  virtual bool         canProduce(TOI const&);
  virtual void         addTOI(TOI&, TOIAbsorber* client);     // exception si pas productible
  virtual set<string>  getAvailOptions(TOI const&);
  virtual long         wontNeedEarlier(TOI const&, TOIAbsorber* client, long);
  virtual void outManifest(RequestHandler*);

protected:
  mutable map<TOI, map<TOI, TOIProducer*> > neededTOIs; // TOI out, TOI in + associated producer, caching.

  virtual set<TOI>     reqTOIFor(TOI const&);
  virtual void         propagateLowBound(TOI const&, long sampleNum);
};


#endif
