// toilldiluproducer.cc
// Eric Aubourg         CEA/DAPNIA/SPP   octobre 1999

#include "toilldiluproducer.h"
#include "archfileset.h"
#include "toimanager.h"
#include "requesthandler.h"

#define   dilDAC           "dilDAC"
#define   dilSwitch        "dilSwitch"
#define   voyantEVO        "voyantEVO"
#define   voyantEVF        "voyantEVF"
#define   commandeEV0      "commandeEV0"
#define   commandeEVF      "commandeEVF"
#define   commandeEVB      "commandeEVB"
#define   commandeEVV      "commandeEVV"
#define   pressEnt3He      "pressEnt3He"
#define   debit3He         "debit3He"
#define   pressSor3He      "pressSor3He"
#define   pressEnt4He      "pressEnt4He"
#define   debit4He         "debit4He"
#define   pressSor4He      "pressSor4He"
#define   pressAirVanne    "pressAirVanne"
#define   pressPompChar    "pressPompChar"
#define   pressMembrane    "pressMembrane"
#define   pressExterne     "pressExterne"
#define   tensPile10T      "tensPile10T"
#define   tensPileP18D     "tensPileP18D"
#define   tensPileM18D     "tensPileM18D"
#define   tensPile10B      "tensPile10B"
#define   tensPileP18B     "tensPileP18B"
#define   tensPileM18B     "tensPileM18B"
#define   tensPileCh       "tensPileCh"
#define   swPile5          "swPile5"
#define   swPile15         "swPile15"
#define   tempCaissH1      "tempCaissH1"
#define   tempCaissH2      "tempCaissH2"
#define   tempCaissB1      "tempCaissB1"
#define   tempCaissB2      "tempCaissB2"
#define   tempCaissTHe     "tempCaissTHe"
#define   tempCaissPiles   "tempCaissPiles"
#define   tempCaissDrv     "tempCaissDrv"
#define   pressHeBain      "pressHeBain"
#define   pressPirani      "pressPirani"


TOILLDiluProducer::TOILLDiluProducer()
{
  possibleTOIs.insert(TOI(dilDAC,        TOI::all,    "", "ADU"));  
  possibleTOIs.insert(TOI(dilSwitch,     TOI::unspec, "", "LONGWORD"));  
  
  possibleTOIs.insert(TOI(voyantEVO,     TOI::unspec, "", "BOOLEAN"));  
  possibleTOIs.insert(TOI(voyantEVF,     TOI::unspec, "", "BOOLEAN"));  
  possibleTOIs.insert(TOI(commandeEV0,   TOI::unspec, "", "BOOLEAN"));  
  possibleTOIs.insert(TOI(commandeEVF,   TOI::unspec, "", "BOOLEAN"));  
  possibleTOIs.insert(TOI(commandeEVB,   TOI::unspec, "", "BOOLEAN"));  
  possibleTOIs.insert(TOI(commandeEVV,   TOI::unspec, "", "BOOLEAN"));  
  
  possibleTOIs.insert(TOI(pressEnt3He,   TOI::unspec, "", "bars"));  
  possibleTOIs.insert(TOI(debit3He,      TOI::unspec, "", "microMoles"));  
  possibleTOIs.insert(TOI(pressSor3He,   TOI::unspec, "", "bars"));  

  possibleTOIs.insert(TOI(pressEnt4He,   TOI::unspec, "", "bars"));  
  possibleTOIs.insert(TOI(debit4He,      TOI::unspec, "", "microMoles"));  
  possibleTOIs.insert(TOI(pressSor4He,   TOI::unspec, "", "bars"));  

  possibleTOIs.insert(TOI(pressAirVanne, TOI::unspec, "", "bars"));  
  possibleTOIs.insert(TOI(pressPompChar, TOI::unspec, "", "bars"));  
  possibleTOIs.insert(TOI(pressMembrane, TOI::unspec, "", "bars"));  
  possibleTOIs.insert(TOI(pressExterne,  TOI::unspec, "", "bars"));  
  
  possibleTOIs.insert(TOI(tensPile10T,   TOI::unspec, "", "Volts"));  
  possibleTOIs.insert(TOI(tensPileP18D,  TOI::unspec, "", "Volts"));  
  possibleTOIs.insert(TOI(tensPileM18D,  TOI::unspec, "", "Volts"));  
  possibleTOIs.insert(TOI(tensPile10B,   TOI::unspec, "", "Volts"));  
  possibleTOIs.insert(TOI(tensPileP18B,  TOI::unspec, "", "Volts"));  
  possibleTOIs.insert(TOI(tensPileM18B,  TOI::unspec, "", "Volts"));  
  possibleTOIs.insert(TOI(tensPileCh,    TOI::unspec, "", "Volts"));  

  possibleTOIs.insert(TOI(swPile5,       TOI::unspec, "", "BOOLEAN"));  
  possibleTOIs.insert(TOI(swPile15,      TOI::unspec, "", "BOOLEAN"));  

  possibleTOIs.insert(TOI(tempCaissH1,   TOI::unspec, "", "Kelvin"));  
  possibleTOIs.insert(TOI(tempCaissH2,   TOI::unspec, "", "Kelvin"));  
  possibleTOIs.insert(TOI(tempCaissB1,   TOI::unspec, "", "Kelvin"));  
  possibleTOIs.insert(TOI(tempCaissB2,   TOI::unspec, "", "Kelvin"));  
  possibleTOIs.insert(TOI(tempCaissTHe,  TOI::unspec, "", "Kelvin"));  
  possibleTOIs.insert(TOI(tempCaissPiles,TOI::unspec, "", "Kelvin"));  
  possibleTOIs.insert(TOI(tempCaissDrv,  TOI::unspec, "", "Kelvin"));  

  possibleTOIs.insert(TOI(pressHeBain,   TOI::unspec, "", "bars"));  
  possibleTOIs.insert(TOI(pressPirani,   TOI::unspec, "", "bars"));  
}

string TOILLDiluProducer::getName() {
  return("TOILLDiluProducer 1.0");
}

#define COMPTOI(_toi_, _func_)                               \
    if ((*i).name == _toi_) {                                 \
      computedValue((*i),sample0, _func_(blk));      \
    }

void TOILLDiluProducer::handleBlock(ArchFileSet* fs)
{
  block_type_dilution* blk = fs->lastDilution();
  long sample0 = numero_block(blk)*72;
  for (set<TOI>::iterator i = producedTOIs.begin(); i != producedTOIs.end(); i++) {
    COMPTOI(voyantEVO,      voyant_EVO) else
    COMPTOI(voyantEVF,      voyant_EVF) else
    COMPTOI(commandeEV0,    commande_EVO) else
    COMPTOI(commandeEVF,    commande_EVF) else
    COMPTOI(commandeEVB,    commande_EVB) else
    COMPTOI(commandeEVV,    commande_EVV) else
    COMPTOI(pressEnt3He,    pression_entree_3He) else
    COMPTOI(debit3He,       debit_3He) else
    COMPTOI(pressSor3He,    pression_sortie_3He) else
    COMPTOI(pressEnt4He,    pression_entree_4He) else
    COMPTOI(debit4He,       debit_4He) else
    COMPTOI(pressSor4He,    pression_sortie_4He) else
    COMPTOI(pressAirVanne,  pression_air_vanne) else
    COMPTOI(pressPompChar,  pression_pompe_charbon) else
    COMPTOI(pressMembrane,  pression_membranne) else
    COMPTOI(pressExterne,   pression_externe) else
    COMPTOI(tensPile10T,    tension_pile_10T) else
    COMPTOI(tensPileP18D,   tension_pile_p18D) else
    COMPTOI(tensPileM18D,   tension_pile_m18D) else
    COMPTOI(tensPile10B,    tension_pile_10B) else
    COMPTOI(tensPileP18B,   tension_pile_p18B) else
    COMPTOI(tensPileM18B,   tension_pile_m18B) else
    COMPTOI(tensPileCh,     tension_pile_Ch) else
    COMPTOI(swPile5,        switch_pile_5) else
    COMPTOI(swPile15,       switch_pile_15) else
    COMPTOI(tempCaissH1,    temperature_caisson_haut1) else
    COMPTOI(tempCaissH2,    temperature_caisson_haut2) else
    COMPTOI(tempCaissB1,    temperature_caisson_bas1) else
    COMPTOI(tempCaissB2,    temperature_caisson_bas2) else
    COMPTOI(tempCaissTHe,   temperature_caisson_tube_helium) else
    COMPTOI(tempCaissPiles, temperature_caisson_piles) else
    COMPTOI(tempCaissDrv,   temperature_caisson_driver_moteur) else
    COMPTOI(pressHeBain,    pression_helium_bain) else
    COMPTOI(pressPirani,    pression_pirani)
    if ((*i).name == dilDAC) {
      int k = (*i).index;
      computedValue((*i), sample0, blk->ADC_dil[k]);
    } else
    if ((*i).name == dilSwitch) {
      computedValue((*i), sample0, blk->switch_dil);
    }
  }
}



