// toimanager.cc
// Eric Aubourg         CEA/DAPNIA/SPP   septembre 1999

#include "toimanager.h"
#include "archexc.h"
#include "toiproducer.h"
//#include "toiabsorber.h"


void TOIManager::registerProducer(TOIProducer* p) {
  producers.insert(p);
}

TOIProducer* TOIManager::findTOIProducer(TOI const& toi) {
  TOIProducer* p = NULL;
  for (set<TOIProducer*>::iterator i=producers.begin();
       i != producers.end(); i++) {
    if ((*i)->canProduce(toi)) {
      if (p) throw ArchExc("Duplicate producers for toi" + toi.name);
      p = *i;
    }    
  }
  if (!p) return NULL; // no producer for this TOI
//  p->addTOI(toi, client);
  return p;
}

set<TOIProducer*> TOIManager::producers;
map<TOILowLevProducer*, long> TOIManager::llProducers;
map<TOILowLevProducer*, long> TOIManager::activeLLProducers;
int TOIManager::trigMask = 0;

void TOIManager::registerLLProducer(TOILowLevProducer* p, int blk_mask) {
  registerProducer(p);
  //trigMask |= blk_mask;
  llProducers[p] = blk_mask;
}

void TOIManager::activateLLProducer(TOILowLevProducer* p) {
  //registerProducer(p);
  int blk_mask = llProducers[p];
  trigMask |= blk_mask;
  activeLLProducers[p] = blk_mask;
}


void TOIManager::dumpAvailTOIs(ostream& s) {
 s << "*** Available TOIs\n";
 for (set<TOIProducer*>::iterator i = producers.begin(); i != producers.end(); i++) {
   TOIProducer* prod = *i;
   set<TOI> x = prod->getPossibleTOIs();
   for (set<TOI>::iterator j = x.begin(); j != x.end(); j++) {
     TOI toi = *j;
     cout << toi.name;
     if (toi.index == TOI::all) cout << " * ";
     for (set<string>::iterator k = toi.options.begin(); k != toi.options.end(); k++) {
       cout << " ";
       if (toi.reqOptions.find(*k) != toi.reqOptions.end()) cout << "+";
       cout << *k;
     }
     cout << "\n";
   }
 }

}



#include "archeopsfile.h"

#include "toillboloproducer.h"
#include "toillreglageproducer.h"
#include "toilldiluproducer.h"
#include "toillgpsproducer.h"
#include "toillgyroproducer.h"
#include "toillsstproducer.h"

#include "timetoiproducer.h"
#include "toiboloproducer.h"
#include "sststarfinder.h"
#include "tsidproducer.h"
#include "galcrosslocator.h"
#include "starmatcher.h"

void TOIManager::registerDefaultProducers() {
  REGLLPROD(TOILLBoloProducer,    block_bolo_mask);
  REGLLPROD(TOILLReglageProducer, block_reglage_mask);
  REGLLPROD(TOILLDiluProducer,    block_dilution_mask);
  REGLLPROD(TOILLGPSProducer,     block_gps_mask);
  REGLLPROD(TOILLGyroProducer,    block_gyro_mask);
  REGLLPROD(TOILLSSTProducer,     block_sst_mask);
  
  REGPROD(TimeTOIProducer);
  REGPROD(TOIBoloProducer);
  REGPROD(SSTStarFinder);
  REGPROD(TSidProducer);
  REGPROD(GalCrossLocator);
  REGPROD(StarMatcher);
}



