#include "transfelec.h"

// D. Yvon, CE Saclay, DAPNIA/SPP, 08/99

// Parametres du circuit electrique de lecture SST
// Valeurs Importantes du circuit electrique: 4 filtres

static double T1=0.15; 		static double C1=1.5e-9;	// Farad
static double T2=5.e-4; 								// secondes
static double R2=1.E9; 									// Ohm
static double T3=4.7e-3; 								// secondes
static double R4=1.e5; 		static double R3=1.8e3;		// Ohm
static double T4=4.84e-3;


Dcomplex TransFuncElec::TsFunc(double w){
	Dcomplex tempComp= H1(w)*H2(w)*H3(w)*H4(w); 			// Omega en radian/s
	return tempComp;
}

Dcomplex TransFuncElec::H1(double w) {
	Dcomplex tempComp=jImagPur*T1*w/(1.+jImagPur*T1*w); 	// passe haut
	return tempComp;
}

Dcomplex TransFuncElec::H2(double w) {
	return R2/(1.+jImagPur*T2*w); 		// passe bas leger
}
		
Dcomplex TransFuncElec::H3(double w) {
	return 1.+ R4/(R3*(1.+jImagPur*T3*w));  // passe bas dominant n1
}
		
Dcomplex TransFuncElec::H4(double w) {
	if (w==0.) return 0.;
	else return 1./(1.+jImagPur*T4*w);		// passe bas dominant n2
}

