#include "generalfit.h"
#include "piscdrawwdg.h"

PIScDrawWdg::PIScDrawWdg(PIContainerGen *par, char *nom,
                         int sx, int sy, int px, int py)
:PIBaseWdg(par, nom, sx, sy, px, py)
{
  mBDrw = new PIDrawer;
  SetSpan();
  SetLimits(-1.,1.,-1.,1.);
  FreeLimits();
  xEndDrag = yEndDrag = xBegDrag = yBegDrag = 0;

  Clip();

  padsup = false;
  mTrlb = mTxw = NULL;
  mTrW = NULL;
  SetTextWin(NULL);

  ActivateButton(1);    // Pour pouvoir activer la fenetre et coordonnees 
  ActivateMove(1);      //    "         "         "        "
  ActivateButton(2);
  ActivateMove(2);

}

PIScDrawWdg::~PIScDrawWdg()
{
  DeleteScDrawers();
  delete mBDrw;
  if (mTrW)  delete mTrW;
}


void
PIScDrawWdg::SetLimits(double xmin, double xmax, double ymin, double ymax,
                       int axrl, int ayud, bool tmp)
{
  if (xmax <= xmin || ymax <= ymin)
    return; // $CHECK$ exception ?
  mBDrw->SetLimits(xmin, xmax, ymin, ymax, axrl, ayud);
  mPPos[0] = 0.5*(XMin()+XMax());
  mPPos[1] = 0.5*(YMin()+YMax());
  if (!tmp) {
    xMinS = xmin;
    xMaxS = xmax;
    yMinS = ymin;
    yMaxS = ymax;
  }
}

void
PIScDrawWdg::Resize()
{
  SetSpan();
  Refresh();
}

void
PIScDrawWdg::SetSpan()
{
  int x0, y0, dx, dy;
  x0 = (int)(XSize()*0.12);
  y0 = (int)(YSize()*0.12);
  dx = (int)(XSize()*0.76+0.5);
  dy = (int)(YSize()*0.76+0.5);
  mBDrw->SetDrwWdg(this, x0, y0, dx, dy);
  return;
}

void
PIScDrawWdg::DrawAxes(int flags)
{
  mBDrw->DrawAxes(flags);
}


void
PIScDrawWdg::SetAxesFlags(int flags)
{
  mBDrw->SetAxesFlags(flags);
}
  

void
PIScDrawWdg::AddScDrawer(PIScDrawer* d, bool ad)
{
  bool pd=false;
  if (mScDrawers.size() == 0)  pd = true;
  mScDrawers.push_back(d);
  d->AttachTo(this, ad, pd);
}

void
PIScDrawWdg::RemoveScDrawer(PIScDrawer* d)
{
  if (padsup)  return;
  vector<PIScDrawer*>::iterator drw;
  for(drw = mScDrawers.begin(); drw != mScDrawers.end(); drw++) 
    if (d == (*drw)) { mScDrawers.erase(drw);  break; }
  d->mDrawWdg = NULL;  d->mDrawer = NULL; 
}

int 
PIScDrawWdg::NbScDrawers()
{
  return(mScDrawers.size());
}

PIScDrawer*
PIScDrawWdg::ScDrawer(int i)
{
 if ( (i<0) || (i>mScDrawers.size()) )  return(NULL);
 return(mScDrawers[i]);
}


void
PIScDrawWdg::DeleteScDrawers()
{
  padsup = true;
  vector<PIScDrawer*>::iterator i;
  for(i = mScDrawers.begin(); i != mScDrawers.end(); i++) {
    if ( (*i)->ADelByDrwWdg() )  delete *i;
  }
  mScDrawers.erase(mScDrawers.begin(),mScDrawers.end());
  padsup = false;
}

void
PIScDrawWdg::CallScDrawers(double xmin, double ymin, double xmax, double ymax)
{
  vector<PIScDrawer*>::iterator drw;
  for(drw = mScDrawers.begin(); drw != mScDrawers.end(); drw++) {
    SaveGraphicAtt();
    (*drw)->SelGraAtt();
    (*drw)->Draw(xmin, ymin, xmax, ymax);
    RestoreGraphicAtt();
  }
}

void
PIScDrawWdg::SetTextWin(PILabel * tw, bool trw, int tx, int ty)
{
mTxw = tw;
if (trw)
  {
  if (mTrW)  mTrW->SetSize(tx, ty);
  else
    {
    mTrW = new PIWindow(this, "Point", PIWK_transient, tx, ty, 0, 0);
    mTrW->SetAutoDelChilds(true);
    mTrlb = new PILabel(mTrW, "PointCoord", tx, ty, 0, 0);
    mTrlb->SetBinding(PIBK_fixed,PIBK_fixed, PIBK_fixed,PIBK_fixed);
    }
  }
else
  if (mTrW) { delete mTrW; mTrW = NULL;  mTrlb = NULL; }

return;
}

void
PIScDrawWdg::Draw()
{
  EraseWindow();
  DrawAxes();
  DrawSelf(-9.e19, -9.e19, 9.e19, 9.e19);
  CallScDrawers(-9.e19, -9.e19, 9.e19, 9.e19);
  CallDrawers(0,0,0,0);
}

void
PIScDrawWdg::Draw(int x0, int y0, int dx, int dy)
{
  double xmin,xmax,ymin,ymax;
  mBDrw->Local2Sc(x0, y0, xmin, ymin);
  mBDrw->Local2Sc(x0+dx, y0+dy, xmax, ymax);
  if (xmin > xmax) swap(xmin,xmax);
  if (ymin > ymax) swap(ymin,ymax);
  DrawAxes();
  DrawSelf(xmin, ymin, xmax, ymax);
  CallScDrawers(xmin, ymin, xmax, ymax);  
  CallDrawers(x0, y0, dx, dy);
}

void
PIScDrawWdg::DrawSelf()
{
return;
}

void
PIScDrawWdg::DrawSelf(double /*xmin*/, double /*ymin*/, double /*xmax*/, double /*ymax*/)
{
return;
}


// Gestion affichage coordonnees du point 
void
PIScDrawWdg::But1Press(int x, int y)
{
  if (UpdateText(x, y))
     {
     if (mTrW)
       { 
       int tpx, tpy;
       GetScreenPos(tpx, tpy);       
       tpy -= (mTrW->YSize()+5);
       if (tpy < 0)  tpy = 0;
       mTrW->SetPos(tpx, tpy);
       mTrW->Show();
       }
     SelPointerShape(PI_CrossPointer);
     }
  Send(Msg(), PIMsg_Active);

}

void
PIScDrawWdg::Ptr1Move(int x, int y)
{
  UpdateText(x, y);
}

void
PIScDrawWdg::But1Release(int x, int y)
{
  if (UpdateText(x, y)) 
    SelPointerShape(PI_ArrowPointer);
  if (mTrW)  mTrW->Hide();
}

bool
PIScDrawWdg::UpdateText(int xp, int yp)
{

  double dx, dy;
  mBDrw->Local2Sc(xp, yp, dx, dy); 
  mPPos[0] = dx;  mPPos[1] = dy; 
  if ((mTxw == NULL) && (mTrlb == NULL)) return(false);

  char buff[128];
  sprintf(buff, "X= %g  Y= %g",  dx, dy);
  if (mTxw)
    mTxw->SetLabel((string)buff);
  if (mTrlb)
    mTrlb->SetLabel((string)buff);
  return(true);

}

// Gestion du zoom
void
PIScDrawWdg::But2Press(int x, int y)
{
  xEndDrag = xBegDrag = x;
  yEndDrag = yBegDrag = y;
  cForCol = GetForeground();
  cGOmod  = GetGOMode();
  cPointer = GetPointerShape();
  cLatt = GetLineAtt();
  SelPointerShape(PI_CrossPointer);
  SelForeground(PI_Magenta);
  SelGOMode(PI_GOXOR);
  SelLine(PI_ThinLine);
  Send(Msg(), PIMsg_Active);
}

void
PIScDrawWdg::But2Release(int /*x*/, int /*y*/)
{

  DrawBox(xBegDrag, yBegDrag, xEndDrag-xBegDrag, yEndDrag-yBegDrag);

  SelForeground(cForCol);
  SelGOMode(cGOmod);
  SelPointerShape(cPointer); 
  SelLine(cLatt); 
  
  if (xBegDrag == xEndDrag || yBegDrag == yEndDrag)
    SetLimits(xMinS, xMaxS, yMinS, yMaxS, kAxeDirSame, kAxeDirSame );
  else {
    double xl,yl,xh,yh;
    mBDrw->Local2Sc(xBegDrag, yBegDrag, xl, yl);
    mBDrw->Local2Sc(xEndDrag, yEndDrag, xh, yh);
    if (xl > xh) swap(xl, xh);
    if (yl > yh) swap(yl, yh);
    SetLimits(xl,xh,yl,yh, kAxeDirSame, kAxeDirSame, true);
  }
  
  Refresh();
}

void
PIScDrawWdg::Ptr2Move(int x, int y)
{
  DrawBox(xBegDrag, yBegDrag, xEndDrag-xBegDrag, yEndDrag-yBegDrag);
  xEndDrag = x;
  yEndDrag = y;
  DrawBox(xBegDrag, yBegDrag, xEndDrag-xBegDrag, yEndDrag-yBegDrag);
}

//================================================================
// PIScDrawer
//================================================================



PIScDrawer::PIScDrawer()
: mDrawWdg(NULL), mDrawer(NULL)
{
  mADbW = mAdDO = mPrDw = false;
  mFCol = mBCol = PI_NotDefColor;
  mLAtt = PI_NotDefLineAtt;
  mFSz = PI_NotDefFontSize;
  mFAtt = PI_NotDefFontAtt;
  mMSz = -1;
  mMrk = PI_NotDefMarker;
}

PIScDrawer::~PIScDrawer()
{
  if (mDrawWdg)
    mDrawWdg->RemoveScDrawer(this);
}

void
PIScDrawer::UpdateSize()
{
// Ne fait rien !
  return;
}

void
PIScDrawer::Refresh()
{
// Recalcule les limites, et reaffiche
  if (!mDrawer) return;
  mDrawWdg->FreeLimits();
  UpdateSize();
  if (mDrawWdg) mDrawWdg->Refresh();
}

void
PIScDrawer::AttachTo(PIScDrawWdg* wdg, bool ad, bool prd)
{
  if (mDrawWdg)
    mDrawWdg->RemoveScDrawer(this);
  mDrawWdg = wdg;  
  mDrawer = wdg->BaseDrawer();
  UpdateSize();
  mADbW = ad;
  mPrDw = prd;
}

// Classe PIDrawer special pour enrober un PIScDrawer en PIDrawer
class PIScContDrw : public PIDrawer {
public :
                     PIScContDrw(PIScDrawer* d, bool ad=false);
  virtual            ~PIScContDrw();
  virtual  void      Draw();
  virtual  void      Draw(double xmin, double ymin, double xmax, double ymax);
private:
  PIScDrawer* mScDrw;
  bool mAD;
};

PIScContDrw::PIScContDrw(PIScDrawer* d, bool ad)  
{ 
  mScDrw = d; 
  mAD=ad; 
}

PIScContDrw::~PIScContDrw() 
{ 
  if (mAD)  delete mScDrw; 
}

void PIScContDrw::Draw() 
{ 
  mScDrw->SelGraAtt(); 
  mScDrw->Draw(-9.e19, -9.e19, 9.e19, 9.e19); 
}

void PIScContDrw::Draw(double xmin, double ymin, double xmax, double ymax)
{ 
  mScDrw->SelGraAtt(); 
  mScDrw->Draw(xmin, ymin, xmax, ymax); 
}

PIDrawer*
PIScDrawer::Convert()
{
  PIScContDrw* rd;
  if (mDrawWdg) mDrawWdg->RemoveScDrawer(this);
  mDrawWdg = NULL; 
  rd = new PIScContDrw(this);
  mDrawer = rd;
  UpdateSize();
  return((PIDrawer*)rd);
}

void 
PIScDrawer::SetColAtt(PIColors fg, PIColors bg)
{
  if (fg != PI_NotDefColor) mFCol = fg;
  if (bg != PI_NotDefColor) mBCol = bg;
}

void 
PIScDrawer::SetLineAtt(PILineAtt lat)
{
  if (lat != PI_NotDefLineAtt) mLAtt = lat;
}

void 
PIScDrawer::SetFontAtt(PIFontSize fsz, PIFontAtt fat)
{
  if (fsz != PI_NotDefFontSize) mFSz = fsz;
  if (fat != PI_NotDefFontAtt) mFAtt = fat;
}

void 
PIScDrawer::SetMarkerAtt(int sz, PIMarker mrk)
{
  if (sz >= 0)  mMSz = sz;
  if (mrk != PI_NotDefMarker) mMrk = mrk;
}

void 
PIScDrawer::SelGraAtt()
{
  if (mDrawer == NULL)   return;
  if (mFCol != PI_NotDefColor)    mDrawer->SelForeground(mFCol);
  if (mBCol != PI_NotDefColor)    mDrawer->SelBackground(mBCol);
  if (mLAtt != PI_NotDefLineAtt)  mDrawer->SelLine(mLAtt);
  if ( (mFSz != PI_NotDefFontSize) || (mFAtt != PI_NotDefFontAtt) )
                                  mDrawer->SelFont(mFSz, mFAtt);
  if ( (mMrk != PI_NotDefMarker) || (mMSz >= 0) )
                                  mDrawer->SelMarker(mMSz, mMrk);
}

//================================================================
// PIScFuncDrawer
//================================================================

PIScFuncDrawer::PIScFuncDrawer(PIScFuncDrawer::FUNC f)
: mFunc(f)
{}

PIScFuncDrawer::~PIScFuncDrawer()
{
}

void
PIScFuncDrawer::Draw(double /*xmin*/, double/*ymin*/, double/*xmax*/, double/*ymax*/)
{
  if (!mDrawer) return;
  double xMax = mDrawer->XMax();
  double xMin = mDrawer->XMin();
  double yMax = mDrawer->YMax();
  double yMin = mDrawer->YMin();
  double xStep = (xMax - xMin)/100;
  double xOld = xMin;
  double yOld = mFunc(xMin);
  for (double x = xMin+xStep; x<xMax; x+=xStep) {
    double y = mFunc(x);
    if (y>yMin && yOld>yMin && 
        y<yMax && yOld<yMax) 
           mDrawer->DrawLine(xOld, yOld, x, y);
    xOld = x;
    yOld = y;
  }
}

//================================================================
// PIScGFFDrawer
//================================================================

PIScGFFDrawer::PIScGFFDrawer(GeneralFunction* f)
: mFunc(f), mNParms(f->NPar()), mParms(new double[mNParms])
{
  ASSERT(f->NVar() == 1);
}

PIScGFFDrawer::~PIScGFFDrawer()
{
  delete[] mParms;
}

void
PIScGFFDrawer::SetParms(double const* p)
{
  for (int i=0; i<mNParms; i++)
    mParms[i] = p[i];
}


void
PIScGFFDrawer::Draw(double /*xmin*/, double/*ymin*/, double/*xmax*/, double/*ymax*/)
{
  if (!mDrawer) return;
  double xMax = mDrawer->XMax();
  double xMin = mDrawer->XMin();
  double yMax = mDrawer->YMax();
  double yMin = mDrawer->YMin();
  double xStep = (xMax - xMin)/100;
  double xOld = xMin;
  double yOld = 0;
//  double yOld = f->Value(&xMin, mParms);
  for (double x = xMin+xStep; x<xMax; x+=xStep) {
   double y = 0; // $CHECK$
//    double y = f->Value(&x, mParms);
    if (y>yMin && yOld>yMin && 
        y<yMax && yOld<yMax) 
           mDrawer->DrawLine(xOld, yOld, x, y);
    xOld = x;
    yOld = y;
  }
}

