// This may look like C code, but it is really -*- C++ -*-
// Classe d ajustement pour  piapp 
// cmv                            98-99
// CEA-DAPNIA      LAL-IN2P3/CNRS

#ifndef PIAFITTING_H_SEEN
#define PIAFITTING_H_SEEN

#include "machdefs.h"
#include <string>
#include <vector>

#include "anydataobj.h"

#include "pdlmgr.h"
#include "dlftypes.h"
#include "piacmd.h"

class PIStdImgApp;
class PIAFitterWind;
class RzImage; //CMV_A_FAIRE class RzImage;

#ifdef SANS_EVOLPLANCK
#include "cvector.h"
class GeneralFunction; class GeneralFunc; class GeneralFit;
class GeneralFitData;
class Histo;  class Histo2D;
#else
#include "tvector.h"
namespace PlanckDPC { 
class GeneralFunction; class GeneralFunc; class GeneralFit;
class GeneralFitData;
class Histo; class Histo2D;
}
#endif

class PIAFitter : public CmdExecutor {
public :
  PIAFitter(PIACmd* piac, PIStdImgApp* app);
  virtual ~PIAFitter();
  virtual int Execute(string& keyw, vector<string>& args);
  virtual void LinkFitFunc(string const& fname, string const& funcname
                          ,int nvar,int npar);
  virtual void PrepareFitFuncCFile(string const& fname, string const& funcname
                                  ,int nvar,int npar);

friend class PIAFitterWind;

protected :

typedef struct DFOptions {
  bool okres, okfun;
  int polcx,polcy; double xc,yc;
  double err_e, err_E;
  double stc2;
  int nstep;
  int lp,lpg;
  int i1,i2,j1,j2;
  bool fromlastfit,autoinifit;
} DFOPTIONS ;

void ResetDPointer(void);
void ResetOptions(void);
void DecodeOptions(string opt);
void DecodeObject(string obj);
void CheckOptions(void);
void PrintOptions(void);
void FillGData(void);
void DecodeFunction(string func);
void ReSetParam(void);
void AutoIniFit(void);
void InitParFromLastFit(void);
void DecodeParam(string par,string step,string min,string max,string fix);
int  DoFit(void);
void FitFunRes(void);
void LinFit(void);

// pour initialiser les parametres du fit
void IniFitP1ou2D(void);
void IniFitGhP1D(void);
void IniFitGvP1D(void);
void IniFitGv2D(void);
static int IniFitGaus(GeneralFitData& g,double& h,double& v
       ,double& x0,double& y0,double& sx,double& sy,double& f);

// Graphique
PIStdImgApp* mApp; // Do not delete
PIAFitterWind* FWindFit; // Fenetre de config interactive
// Objet a fitter
string mNObj; AnyDataObj* mObj; // Do not delete
// Structure de data pour le fit, parametres et options
GeneralFitData* mGData;
int mNPar,mNVar,mNBinX,mNBinY,mNData;
Vector mPar; Vector mStep; Vector mMin; Vector mMax; Vector mFix;
Vector mParSave; Vector mStepSave; Vector mMinSave; Vector mMaxSave; Vector mFixSave;
GeneralFit* mFit;
DFOPTIONS mOpt;
DFOPTIONS mOptSave;
// Possibles objets a fitter
Vector* mV; Histo* mH; // Do not delete
Matrix* mM; Histo2D* mH2; // Do not delete
RzImage* mIm; // Do not delete
GeneralFitData* mG; // Do not delete
// Gestion des fonctions de fit predefinies
GeneralFunction* mFunction; string mFName;
// Gestion de fonction de fit definie par l'utilisateur
GeneralFunc* mFunc;
PDynLinkMgr* mDlUFunc;
string mNameFitFunc;
DlUserFitFunc mFitFunc;
DlUserFitFuncDer mFitFuncDer;
int mUFNVar, mUFNPar; 
};

#endif
