// This may look like C code, but it is really -*- C++ -*-
//
// $Id: linfit.h,v 1.6 1999-11-05 13:08:30 ansari Exp $
//

// Routines de fit lineaire, avec ou sans erreurs, en fournissant
// les fonctions ou les valeurs.
#ifndef LINFIT_SEEN
#define LINFIT_SEEN

#include "machdefs.h"
#include "tvector.h"

namespace SOPHYA {

class LinFitter {
public :
		LinFitter();
  virtual	~LinFitter();

  double	LinFit(const Vector& x, const Vector& y, int nf,
		       double (*f)(int, double), Vector& c);
// fit lineaire des y en tant que somme de c(i)f(i,x), i=0..nf-1;

  double	LinFit(const Matrix& fx, const Vector& y, Vector& c);
// fit lineaire des y en tant que somme de c(i)f(i,x), i=0..nf-1,
// la matrice fx contient les valeurs des f:
// fx(i,j) = f(i, x(j)).
		      
  double	LinFit(const Vector& x, const Vector& y, const Vector& errY2, int nf,
		       double (*f)(int, double), Vector& c, Vector& errC);
// fit lineaire des y en tant que somme de c(i)f(i,x), i=0..nf-1,
// errY2 contient les carres des erreurs sur les Y.
// au retour, errC contient les erreurs sur les coefs.

  double	LinFit(const Matrix& fx, const Vector& y, const Vector& errY2,
		       Vector& c, Vector& errC);
// fit lineaire des y en tant que somme de c(i)f(i,x), i=0..nf-1,
// la matrice fx contient les valeurs des f:
// fx(i,j) = f(i, x(j)).
// errY2 contient les carres des erreurs sur les Y.
// au retour, errC contient les erreurs sur les coefs.
};

} // Fin du namespace

#endif // LINFIT_SEEN 
