// This may look like C code, but it is really -*- C++ -*-
#ifndef SPHEREPOS_H_SEEN
#define SPHEREPOS_H_SEEN

#include "machdefs.h"
#include "ppersist.h"
#include <string>
#include "unitvector.h"

static char *head_spherepos_h_ = "$Header: /Users/garnier/temp/CVSSophya/SophyaLib/Samba/spherepos.h,v 1.3 1999-11-05 13:10:10 ansari Exp $";

namespace SOPHYA {

enum SphereCoordSysIds { SphereCoordSys_NEUTRAL =0, 
                         SphereCoordSys_ROTATION =1,
                         SphereCoordSys_OTHER = 0xFFFF
};

// We make this class a PPersist class, in order
// to be able to implement easily the persistence 
// for pixelmaps
// To be changed later ($CHECK$  Reza 26/10/99) 
 
class SphereCoordSys : public PPersist {
public:
  
                 SphereCoordSys();
                 SphereCoordSys(int id, const string& description);
  virtual        ~SphereCoordSys();

  virtual int    Id() const {return id_; }
  virtual string description() const {return description_; }

    // METHODS FOR PERSISTENCE TO FOLLOW:
protected:
  virtual void       ReadSelf(PInPersist&);
  virtual void       WriteSelf(POutPersist&) const;

private:
  int id_;
  string description_;
};


class SpherePosition : public UnitVector {
public:
  
                 SpherePosition();
// cs should be created by new SphereCoordSys...
// It will be deleted by the destructor
                 SpherePosition(double theta, double phi, SphereCoordSys* cs = NULL);
                 SpherePosition(double x, double y, double z, SphereCoordSys* cs = NULL);
                 SpherePosition(const UnitVector& v, SphereCoordSys* cs = NULL);
  virtual        ~SpherePosition();

  inline double  phi() const {return Phi(); }
  inline double  theta() const { return(Theta()); }
  inline SphereCoordSys *   GetCoordSys() const { return(cs_); } 
  virtual UnitVector Transform(const SphereCoordSys& cs) const ;

  virtual double     Separation(const SpherePosition& gamma) const;

protected:
  SphereCoordSys* cs_;
};

} // Fin du namespace

#endif
