// This may look like C code, but it is really -*- C++ -*-
#ifndef TOD_H_SEEN
#define TOD_H_SEEN

#include "machdefs.h"
#include "spherepos.h"
#include "misstime.h"

namespace SOPHYA {
template<class T>
class TOD 
{
public:
		TOD(SphereCoordSys* cs = NULL)
                    { if (cs) cs_ = cs; else cs = new SphereCoordSys; }
  virtual 	~TOD()
                    { if (cs_) delete cs_; }

// Set/Change/Get the coordinate system
  virtual void  SetCoordSys(SphereCoordSys* cs)
                    { if (cs) { delete cs_;  cs_ = cs; } }
  inline SphereCoordSys* GetCoordSys() const { return(cs_); }

// Return the size / number of sample
  virtual int_8 size() const = 0; 
  inline  int_8 NbSample() const { return(size()); }

// Start/End time
  virtual MissionTime StartTime();
  virtual MissionTime EndTime();

// Sample time 
  virtual const MissionTime& SampleTime(int k) const = 0;
  virtual MissionTime& SampleTime(int k) = 0;

// Time to sample number - return the closest sample to time t
  virtual int_8 IndexFromTime(MissionTime const & t) const = 0;

// Sample value
  virtual const T& SampleValue(int_8 k) const = 0;
  virtual T& SampleValue(int_8 k) = 0;
  virtual const T& ValueAtTime(MissionTime const & t) const 
		{ return SampleValue(IndexFromTime(t)); }

// Sample direction
  virtual const UnitVector& SamplePointing(int_8 k) const = 0;
  virtual UnitVector& SamplePointing(int_8 k) = 0;
// Pointing at time t
  virtual const UnitVector& PointingAtTime(MissionTime const & t ) const 
		{ return SamplePointing(IndexFromTime(t)); }

};

} // Fin du namespace

#endif
