// toi.h
// Eric Aubourg         CEA/DAPNIA/SPP   septembre 1999

#ifndef TOI_H
#define TOI_H

#include<string>
#include<set>
#include<vector>
using namespace std;

struct TOI {
  TOI() : name(""), index(unspec) {}
  TOI(string n, int i, string opts="", string u="");
  TOI(string n, int i, set<string> opts, string u="");
  TOI(string, string u="");
  TOI(string n, int i, string opts, string u, string reqopts);
  
  string name;
  set<string> options;
  set<string> reqOptions; // Used for possibleTOIs... Mandatory options for a producer.
  int index;   // -1 : unspecified. -2 : all.
  enum {unspec = -1, all = -2};
  string unit;
  inline bool operator == (TOI const&) const;
  inline bool operator <  (TOI const&) const;
  
  int ref;
  static vector<TOI> alltois;
  void findref();
  
  string fullName() const;
};

bool TOI::operator == (TOI const& x) const {
  return ref == x.ref;
  //return (name == x.name && options == x.options && index == x.index);
}

bool TOI::operator < (TOI const& x) const {
  return ref < x.ref;
  #if 0
  return ((name < x.name) ||
          (name == x.name && options < x.options) ||
          (name == x.name && options == x.options && index < x.index));
  #endif
}

#endif
