// gyrocalibrator.h
// Eric Aubourg         CEA/DAPNIA/SPP   octobre 1999

#ifndef GYROCALIBRATOR_H
#define GYROCALIBRATOR_H

#include "toipullproducer.h"

#include <vector>

class GyroCalibrator : public TOIPullProducer {
public:
  GyroCalibrator();
  virtual void dataFeed(TOIProducer* source, TOI const& toi, long sampleNum, double value);
  virtual string getName();

  virtual bool   canGetValue(long sampleNum, TOI const& toi); // for this samplenum
  virtual bool   canGetValueLater(long sampleNum, TOI const& toi);  // Might, later but not now
  
  virtual double getValue(long sampleNum, TOI const& toi);
  
protected:
  virtual set<TOI>     reqTOIFor(TOI const&);
  virtual void         propagateLowBound(TOI const&, long sampleNum);
  
  virtual void recomputeCalib();
  virtual bool fetchFences(long sampleNum);
  
  
  long startSample;
  vector<double> gyro[3]; 
  long lastFence1, lastFence2;
  double lastRotSpeed; // on gyro 2
  double lastCalib[3];
  double lastOffset[3];
  TOIProducer* gyroProducer;
};



#endif
