// starmatcher.h
// Eric Aubourg         CEA/DAPNIA/SPP   novembre 1999

#ifndef STARMATCHER_H
#define STARMATCHER_H


#include "sststarfinder.h"
#include "toiderivproducer.h"

class StarMatcher: public SSTStarProcessor, public TOIDerivProducer {
public:
  StarMatcher();
  
  virtual void dataFeed(SSTEtoile const&); 

  virtual string getName();
  virtual double getValue(long sampleNum, TOI const& toi);
  virtual bool   canGetValue(long sampleNum, TOI const& toi);
  virtual bool   canGetValueLater(long sampleNum, TOI const& toi);

protected:
  virtual set<TOI>     reqTOIFor(TOI const&);
  void propagateLowBound(TOI const& toi, long sampleNum);
  void processStars();

  struct gscStar {
    float ra;
    float dec;
    short mag; // mag * 100
  };

  
  gscStar* stars;
  long nstars;
  
  deque<SSTEtoile> lastStars;
  
  struct matchStar {
    double SN;
    double raGSC;
    double decGSC;
    double azGSC;
    double elvGSC;
    int    nDiode;
    bool   ok;
    long   seq;
    double lon;
    double lat;
    double ts;
  };
  
  long lastSeq;
  
  deque<matchStar> matchStars;
  deque<matchStar> cleanStars;
  
  struct pendulInfo {
    double SN;
    double azPendul;
    double angPendul;
  };
  
  struct posInfo {
    double SN;
    double azStar;
    double elvStar;
    double diodStar;
    double lon;
    double lat;
    double ts;
  };
  
  map<double, posInfo> posInfos; // sampleNum -> info
  map<double, pendulInfo> pendulInfos; // sampleNum -> info
  
  int getPendulInfo(double sampleNum, pendulInfo& info); // interpolate
  
};


#endif
