// toiboloproducer.cc
// Eric Aubourg         CEA/DAPNIA/SPP   septembre 1999

#include "toiboloproducer.h"
#include "archexc.h"
#include "requesthandler.h"

#define filt2 "boloMuV"


TOIBoloProducer::TOIBoloProducer() {
  possibleTOIs.insert(TOI(filt2, TOI::all, "", "microVolts"));  
}

string TOIBoloProducer::getName() {
  return("TOIBoloProducer 1.0");
}


void TOIBoloProducer::dataFeed(TOIProducer* source, TOI const& toi, long sampleNum, double value) {
  if (source->canGetValue(sampleNum-1, toi)) {
    value = (value + source->getValue(sampleNum-1, toi))/2.;
    TOI toi2 = toi;
    toi2.name = filt2;
    computedValue(toi2, sampleNum, value);
  }
}

set<TOI> TOIBoloProducer::reqTOIFor(TOI const& toi) {
  TOI toi2 = toi;
  set<TOI> t; 
  if (toi.name == filt2) {
    toi2.name = "boloRawMuV";
    t.insert(toi2);
  } else {
    throw ArchExc("Cannot produce "+toi.name);
  }
  return t;
}


void TOIBoloProducer::propagateLowBound(TOI const& toi, long sampleNum) {
  CHKPROD
  map<TOI, TOIProducer*> & need = neededTOIs[toi];
  int hlen = 1;
  for (map<TOI, TOIProducer*>::iterator i = need.begin(); i != need.end(); i++) {
    (*i).second->wontNeedEarlier((*i).first, this, sampleNum-hlen);
  }
}



